/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.inbound;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.endpoint.ExpressionMessageProducerSupport;
import org.springframework.integration.gemfire.inbound.EventType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class CacheListeningMessageProducer
extends ExpressionMessageProducerSupport {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Region region;
    private final CacheListener<?, ?> listener;
    private volatile Set<EventType> supportedEventTypes = new HashSet<EventType>(Arrays.asList(EventType.CREATED, EventType.UPDATED));

    public CacheListeningMessageProducer(Region<?, ?> region) {
        Assert.notNull(region, (String)"region must not be null");
        this.region = region;
        this.listener = new MessageProducingCacheListener();
    }

    public void setSupportedEventTypes(EventType ... eventTypes) {
        Assert.notEmpty((Object[])eventTypes, (String)"eventTypes must not be empty");
        this.supportedEventTypes = new HashSet<EventType>(Arrays.asList(eventTypes));
    }

    public String getComponentType() {
        return "gemfire:inbound-channel-adapter";
    }

    protected void doStart() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("adding MessageProducingCacheListener to GemFire Region '" + this.region.getName() + "'"));
        }
        this.region.getAttributesMutator().addCacheListener(this.listener);
    }

    protected void doStop() {
        block3: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("removing MessageProducingCacheListener from GemFire Region '" + this.region.getName() + "'"));
            }
            try {
                this.region.getAttributesMutator().removeCacheListener(this.listener);
            }
            catch (CacheClosedException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private class MessageProducingCacheListener
    extends CacheListenerAdapter {
        private MessageProducingCacheListener() {
        }

        public void afterCreate(EntryEvent event) {
            if (CacheListeningMessageProducer.this.supportedEventTypes.contains((Object)EventType.CREATED)) {
                this.processEvent(event);
            }
        }

        public void afterUpdate(EntryEvent event) {
            if (CacheListeningMessageProducer.this.supportedEventTypes.contains((Object)EventType.UPDATED)) {
                this.processEvent(event);
            }
        }

        public void afterInvalidate(EntryEvent event) {
            if (CacheListeningMessageProducer.this.supportedEventTypes.contains((Object)EventType.INVALIDATED)) {
                this.processEvent(event);
            }
        }

        public void afterDestroy(EntryEvent event) {
            if (CacheListeningMessageProducer.this.supportedEventTypes.contains((Object)EventType.DESTROYED)) {
                this.processEvent(event);
            }
        }

        private void processEvent(EntryEvent event) {
            this.publish(CacheListeningMessageProducer.this.evaluatePayloadExpression(event));
        }

        private void publish(Object object) {
            Message message = null;
            message = object instanceof Message ? (Message)object : CacheListeningMessageProducer.this.getMessageBuilderFactory().withPayload(object).build();
            CacheListeningMessageProducer.this.sendMessage(message);
        }
    }
}

