/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.outbound;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.Region;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.gemfire.GemfireCallback;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class CacheWritingMessageHandler
extends AbstractMessageHandler {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final Map<Expression, Expression> cacheEntryExpressions = new LinkedHashMap<Expression, Expression>();
    private final GemfireTemplate gemfireTemplate = new GemfireTemplate();
    private volatile EvaluationContext evaluationContext;

    public CacheWritingMessageHandler(Region region) {
        Assert.notNull((Object)region, (String)"region must not be null");
        this.gemfireTemplate.setRegion(region);
    }

    public String getComponentType() {
        return "gemfire:outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        this.gemfireTemplate.afterPropertiesSet();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) {
        Map cacheValues;
        Object payload = message.getPayload();
        Map map = cacheValues = this.cacheEntryExpressions.size() > 0 ? this.evaluateCacheEntries(message) : null;
        if (cacheValues == null) {
            Assert.state((boolean)(payload instanceof Map), (String)"If cache entry expressions are not configured, then payload must be a Map");
            cacheValues = (Map)payload;
        }
        final Map map2 = cacheValues;
        this.gemfireTemplate.execute((GemfireCallback)new GemfireCallback<Object>(){

            public Object doInGemfire(Region region) throws GemFireCheckedException, GemFireException {
                region.putAll(map2);
                return null;
            }
        });
    }

    private Map<Object, Object> evaluateCacheEntries(Message<?> message) {
        if (this.cacheEntryExpressions.size() == 0) {
            return null;
        }
        HashMap<Object, Object> cacheValues = new HashMap<Object, Object>();
        for (Map.Entry<Expression, Expression> expressionEntry : this.cacheEntryExpressions.entrySet()) {
            cacheValues.put(expressionEntry.getKey().getValue(this.evaluationContext, message), expressionEntry.getValue().getValue(this.evaluationContext, message));
        }
        return cacheValues;
    }

    public void setCacheEntries(Map<String, String> cacheEntries) {
        Assert.notNull(cacheEntries, (String)"'cacheEntries' must not be null");
        if (this.cacheEntryExpressions.size() > 0) {
            this.cacheEntryExpressions.clear();
        }
        for (Map.Entry<String, String> cacheEntry : cacheEntries.entrySet()) {
            this.cacheEntryExpressions.put(PARSER.parseExpression(cacheEntry.getKey()), PARSER.parseExpression(cacheEntry.getValue()));
        }
    }

    public void setCacheEntryExpressions(Map<Expression, Expression> cacheEntryExpressions) {
        Assert.notNull(cacheEntryExpressions, (String)"'cacheEntryExpressions' must not be null");
        if (this.cacheEntryExpressions.size() > 0) {
            this.cacheEntryExpressions.clear();
        }
        this.cacheEntryExpressions.putAll(cacheEntryExpressions);
    }
}

