/*
 * Copyright 2015-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.hazelcast;

/**
 * Enumeration of Hazelcast Cluster Monitor Types.
 *
 * @author Eren Avsarogullari
 * @author Artem Bilan
 *
 * @since 1.0.0
 *
 * @see org.springframework.integration.hazelcast.inbound.HazelcastClusterMonitorMessageProducer
 * @see com.hazelcast.core.MembershipListener
 * @see com.hazelcast.core.DistributedObjectListener
 * @see com.hazelcast.core.MigrationListener
 * @see com.hazelcast.core.LifecycleListener
 * @see com.hazelcast.core.ClientListener
 */
public enum ClusterMonitorType {

	/**
	 * The membership listener mode.
	 */
	MEMBERSHIP,

	/**
	 * The distributed object listener mode.
	 */
	DISTRIBUTED_OBJECT,

	/**
	 * The migration listener mode.
	 */
	MIGRATION,

	/**
	 * The listener listener mode.
	 */
	LIFECYCLE,

	/**
	 * The client listener mode.
	 */
	CLIENT

}
