/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.ReplicatedMap;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.integration.hazelcast.CacheEventType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class HazelcastIntegrationDefinitionValidator {
    public static <E extends Enum<E>> Set<String> validateEnumType(Class<E> enumType, String types) {
        Set typeSet = StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)types));
        for (String type : typeSet) {
            Enum.valueOf(enumType, type);
        }
        return typeSet;
    }

    public static void validateCacheTypeForEventDrivenMessageProducer(DistributedObject distributedObject) {
        if (!(distributedObject instanceof IMap || distributedObject instanceof MultiMap || distributedObject instanceof ReplicatedMap || distributedObject instanceof IList || distributedObject instanceof ISet || distributedObject instanceof IQueue || distributedObject instanceof ITopic)) {
            throw new IllegalArgumentException("Invalid 'cache' type is set. IMap, MultiMap, ReplicatedMap, IList, ISet, IQueue and ITopic cache object types are acceptable for Hazelcast Inbound Channel Adapter.");
        }
    }

    public static void validateCacheEventsByDistributedObject(DistributedObject distributedObject, Set<String> cacheEventTypeSet) {
        List<String> supportedCacheEventTypes = HazelcastIntegrationDefinitionValidator.getSupportedCacheEventTypes(distributedObject);
        if (!CollectionUtils.isEmpty(supportedCacheEventTypes)) {
            HazelcastIntegrationDefinitionValidator.validateCacheEventsByDistributedObject(distributedObject, cacheEventTypeSet, supportedCacheEventTypes);
        }
    }

    private static List<String> getSupportedCacheEventTypes(DistributedObject distributedObject) {
        if (distributedObject instanceof IList || distributedObject instanceof ISet || distributedObject instanceof IQueue) {
            return Arrays.asList(CacheEventType.ADDED.toString(), CacheEventType.REMOVED.toString());
        }
        if (distributedObject instanceof MultiMap) {
            return Arrays.asList(CacheEventType.ADDED.toString(), CacheEventType.REMOVED.toString(), CacheEventType.CLEAR_ALL.toString());
        }
        if (distributedObject instanceof ReplicatedMap) {
            return Arrays.asList(CacheEventType.ADDED.toString(), CacheEventType.REMOVED.toString(), CacheEventType.UPDATED.toString(), CacheEventType.EVICTED.toString());
        }
        return null;
    }

    private static void validateCacheEventsByDistributedObject(DistributedObject distributedObject, Set<String> cacheEventTypeSet, List<String> supportedCacheEventTypes) {
        if (!supportedCacheEventTypes.containsAll(cacheEventTypeSet)) {
            throw new IllegalArgumentException("'cache-events' attribute of " + distributedObject.getName() + " can be set as " + supportedCacheEventTypes);
        }
    }

    private HazelcastIntegrationDefinitionValidator() {
    }
}

