/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.inbound;

import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.util.Collection;
import java.util.Collections;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.hazelcast.DistributedSQLIterationType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class HazelcastDistributedSQLMessageSource
extends AbstractMessageSource {
    private final IMap<?, ?> distributedMap;
    private final String distributedSql;
    private DistributedSQLIterationType iterationType = DistributedSQLIterationType.VALUE;

    public HazelcastDistributedSQLMessageSource(IMap distributedMap, String distributedSql) {
        Assert.notNull((Object)distributedMap, (String)"'distributedMap' must not be null");
        Assert.hasText((String)distributedSql, (String)"'distributedSql' must not be empty");
        this.distributedMap = distributedMap;
        this.distributedSql = distributedSql;
    }

    public void setIterationType(DistributedSQLIterationType iterationType) {
        Assert.notNull((Object)((Object)this.iterationType), (String)"'iterationType' must not be null");
        this.iterationType = iterationType;
    }

    public String getComponentType() {
        return "hazelcast:ds-inbound-channel-adapter";
    }

    protected Collection<?> doReceive() {
        switch (this.iterationType) {
            case ENTRY: {
                return this.getDistributedSQLResultSet(Collections.unmodifiableCollection(this.distributedMap.entrySet((Predicate)new SqlPredicate(this.distributedSql))));
            }
            case KEY: {
                return this.getDistributedSQLResultSet(Collections.unmodifiableCollection(this.distributedMap.keySet((Predicate)new SqlPredicate(this.distributedSql))));
            }
            case LOCAL_KEY: {
                return this.getDistributedSQLResultSet(Collections.unmodifiableCollection(this.distributedMap.localKeySet((Predicate)new SqlPredicate(this.distributedSql))));
            }
        }
        return this.getDistributedSQLResultSet(this.distributedMap.values((Predicate)new SqlPredicate(this.distributedSql)));
    }

    private Collection<?> getDistributedSQLResultSet(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        return collection;
    }
}

