/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.outbound;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class HazelcastCacheWritingMessageHandler
extends AbstractMessageHandler {
    private DistributedObject distributedObject;
    private Expression cacheExpression;
    private Expression keyExpression;
    private boolean extractPayload = true;
    private EvaluationContext evaluationContext;

    public void setDistributedObject(DistributedObject distributedObject) {
        Assert.notNull((Object)distributedObject, (String)"'distributedObject' must not be null");
        this.distributedObject = distributedObject;
    }

    public void setCacheExpression(Expression cacheExpression) {
        Assert.notNull((Object)cacheExpression, (String)"'cacheExpression' must not be null");
        this.cacheExpression = cacheExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"'keyExpression' must not be null");
        this.keyExpression = keyExpression;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) {
        DistributedObject distributedObject;
        Object objectToStore = message;
        if (this.extractPayload) {
            objectToStore = message.getPayload();
        }
        if ((distributedObject = this.getDistributedObject(message)) instanceof Map) {
            Map map = (Map)distributedObject;
            if (objectToStore instanceof Map) {
                map.putAll((Map)objectToStore);
            } else if (objectToStore instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)objectToStore;
                map.put(entry.getKey(), entry.getValue());
            } else {
                map.put(this.getKey(message), objectToStore);
            }
        } else if (distributedObject instanceof MultiMap) {
            MultiMap map = (MultiMap)distributedObject;
            if (objectToStore instanceof Map) {
                Map mapToStore = (Map)objectToStore;
                for (Map.Entry entry : mapToStore.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
            } else if (objectToStore instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)objectToStore;
                map.put(entry.getKey(), entry.getValue());
            } else {
                map.put(this.getKey(message), objectToStore);
            }
        } else if (distributedObject instanceof ITopic) {
            ((ITopic)distributedObject).publish(objectToStore);
        } else if (distributedObject instanceof Collection) {
            if (objectToStore instanceof Collection) {
                ((Collection)distributedObject).addAll((Collection)objectToStore);
            } else {
                ((Collection)distributedObject).add(objectToStore);
            }
        } else {
            throw new IllegalStateException("The 'distributedObject' for 'HazelcastCacheWritingMessageHandler' must be of 'IMap', 'MultiMap', 'ITopic', 'ISet' or 'IList' type, but gotten: [" + distributedObject + "].");
        }
    }

    private DistributedObject getDistributedObject(Message<?> message) {
        if (this.distributedObject != null) {
            return this.distributedObject;
        }
        if (this.cacheExpression != null) {
            return (DistributedObject)this.cacheExpression.getValue(this.evaluationContext, message, DistributedObject.class);
        }
        if (message.getHeaders().containsKey((Object)"hazelcast_cacheName")) {
            return (DistributedObject)this.getBeanFactory().getBean((String)message.getHeaders().get((Object)"hazelcast_cacheName", String.class), DistributedObject.class);
        }
        throw new IllegalStateException("One of 'cache', 'cache-expression' and hazelcast_cacheName must be set for cache object definition.");
    }

    private Object getKey(Message<?> message) {
        if (this.keyExpression != null) {
            return this.keyExpression.getValue(this.evaluationContext, message);
        }
        throw new IllegalStateException("'key-expression' must be set to place the raw 'payload' to the IMap, MultiMap and ReplicatedMap");
    }
}

