/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.http.config.HttpAdapterParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler");
        builder.addConstructorArgValue((Object)element.getAttribute("url"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"http-method");
        String restTemplate = element.getAttribute("rest-template");
        if (StringUtils.hasText((String)restTemplate)) {
            HttpAdapterParsingUtils.verifyNoRestTemplateAttributes(element, parserContext);
            builder.addConstructorArgReference("restTemplate");
        } else {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converters");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-handler");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-factory");
        }
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        String mappedResponseHeaders = element.getAttribute("mapped-response-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders) || StringUtils.hasText((String)mappedResponseHeaders)) {
                parserContext.getReaderContext().error("Neither 'mappped-request-headers' or 'mapped-response-headers' attributes are allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
                return null;
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else if (StringUtils.hasText((String)mappedRequestHeaders) || StringUtils.hasText((String)mappedResponseHeaders)) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.support.DefaultHttpHeaderMapper");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"outboundHeaderNames");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-response-headers", (String)"inboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-request-payload", (String)"extractPayload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"expected-response-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        List uriVariableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"uri-variable");
        if (!CollectionUtils.isEmpty((Collection)uriVariableElements)) {
            HashMap<String, String> uriVariableExpressions = new HashMap<String, String>();
            for (Element uriVariableElement : uriVariableElements) {
                String name = uriVariableElement.getAttribute("name");
                String expression = uriVariableElement.getAttribute("expression");
                uriVariableExpressions.put(name, expression);
            }
            builder.addPropertyValue("uriVariableExpressions", uriVariableExpressions);
        }
        return builder;
    }
}

