/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.http.MediaType;
import org.springframework.integration.http.multipart.MultipartFileReader;
import org.springframework.web.multipart.MultipartFile;

public class SimpleMultipartFileReader
implements MultipartFileReader<Object> {
    private volatile Charset defaultCharset = Charset.forName("ISO-8859-1");

    public void setDefaultMultipartCharset(String defaultCharset) {
        this.defaultCharset = Charset.forName(defaultCharset != null ? defaultCharset : "ISO-8859-1");
    }

    @Override
    public Object readMultipartFile(MultipartFile multipartFile) throws IOException {
        if (multipartFile.getContentType() != null && multipartFile.getContentType().startsWith("text")) {
            MediaType contentType = MediaType.parseMediaType((String)multipartFile.getContentType());
            Charset charset = contentType.getCharSet();
            if (charset == null) {
                charset = this.defaultCharset;
            }
            return new String(multipartFile.getBytes(), charset.name());
        }
        return multipartFile.getBytes();
    }
}

