/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.dsl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.Expression;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class BaseHttpMessageHandlerSpec<S extends BaseHttpMessageHandlerSpec<S, E>, E extends AbstractHttpRequestExecutingMessageHandler>
extends MessageHandlerSpec<S, E>
implements ComponentsRegistration {
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private boolean headerMapperExplicitlySet;

    public BaseHttpMessageHandlerSpec(E handler) {
        this.target = handler;
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setHeaderMapper(this.headerMapper);
    }

    protected S expectReply(boolean expectReply) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setExpectReply(expectReply);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S encodeUri(boolean encodeUri) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setEncodeUri(encodeUri);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S httpMethodExpression(Expression httpMethodExpression) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setHttpMethodExpression(httpMethodExpression);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public <P> S httpMethodFunction(Function<Message<P>, ?> httpMethodFunction) {
        return this.httpMethodExpression((Expression)new FunctionExpression(httpMethodFunction));
    }

    public S httpMethod(HttpMethod httpMethod) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setHttpMethod(httpMethod);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S extractPayload(boolean extractPayload) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setExtractPayload(extractPayload);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S charset(String charset) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setCharset(charset);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S expectedResponseType(Class<?> expectedResponseType) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setExpectedResponseType(expectedResponseType);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S expectedResponseType(ParameterizedTypeReference<?> expectedResponseType) {
        return this.expectedResponseTypeExpression((Expression)new ValueExpression(expectedResponseType));
    }

    public S expectedResponseTypeExpression(Expression expectedResponseTypeExpression) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setExpectedResponseTypeExpression(expectedResponseTypeExpression);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public <P> S expectedResponseTypeFunction(Function<Message<P>, ?> expectedResponseTypeFunction) {
        return this.expectedResponseTypeExpression((Expression)new FunctionExpression(expectedResponseTypeFunction));
    }

    public S headerMapper(HeaderMapper<HttpHeaders> headerMapper) {
        this.headerMapper = headerMapper;
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setHeaderMapper(this.headerMapper);
        this.headerMapperExplicitlySet = true;
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S mappedRequestHeaders(String ... patterns) {
        Assert.isTrue((!this.headerMapperExplicitlySet ? 1 : 0) != 0, (String)("The 'mappedRequestHeaders' must be specified on the provided 'headerMapper': " + this.headerMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setOutboundHeaderNames(patterns);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S mappedResponseHeaders(String ... patterns) {
        Assert.isTrue((!this.headerMapperExplicitlySet ? 1 : 0) != 0, (String)("The 'mappedResponseHeaders' must be specified on the provided 'headerMapper': " + this.headerMapper));
        ((DefaultHttpHeaderMapper)this.headerMapper).setInboundHeaderNames(patterns);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S uriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        this.uriVariableExpressions.clear();
        this.uriVariableExpressions.putAll(uriVariableExpressions);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S uriVariable(String variable, Expression expression) {
        this.uriVariableExpressions.put(variable, expression);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public S uriVariable(String variable, String expression) {
        return this.uriVariable(variable, PARSER.parseExpression(expression));
    }

    public <P> S uriVariable(String variable, Function<Message<P>, ?> valueFunction) {
        return this.uriVariable(variable, (Expression)new FunctionExpression(valueFunction));
    }

    public S uriVariablesExpression(String uriVariablesExpression) {
        return this.uriVariablesExpression(PARSER.parseExpression(uriVariablesExpression));
    }

    public S uriVariablesExpression(Expression uriVariablesExpression) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setUriVariablesExpression(uriVariablesExpression);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public <P> S uriVariablesFunction(Function<Message<P>, Map<String, ?>> uriVariablesFunction) {
        return this.uriVariablesExpression((Expression)new FunctionExpression(uriVariablesFunction));
    }

    public S transferCookies(boolean transferCookies) {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setTransferCookies(transferCookies);
        return (S)((Object)((BaseHttpMessageHandlerSpec)this._this()));
    }

    public Map<Object, String> getComponentsToRegister() {
        ((AbstractHttpRequestExecutingMessageHandler)((Object)this.target)).setUriVariableExpressions(this.uriVariableExpressions);
        return Collections.singletonMap(this.headerMapper, null);
    }

    protected abstract boolean isClientSet();
}

