/*
 * Copyright 2016-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.http.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * @author Artem Bilan
 *
 * @since 4.3
 */
class IntegrationGraphControllerRegistrarImportSelector implements ImportSelector {

	private static final Log LOGGER = LogFactory.getLog(IntegrationGraphControllerRegistrarImportSelector.class);

	@Override
	public String[] selectImports(AnnotationMetadata importingClassMetadata) {
		if (HttpContextUtils.WEB_MVC_PRESENT || HttpContextUtils.WEB_FLUX_PRESENT) {
			return new String[] { IntegrationGraphControllerRegistrar.class.getName() };
		}
		else {
			LOGGER.warn("The 'IntegrationGraphController' isn't registered with the application context because" +
					" there is no 'org.springframework.web.servlet.DispatcherServlet' or" +
					" 'org.springframework.web.reactive.DispatcherHandler' in the classpath.");
			return new String[0];
		}
	}

}
