/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.ResolvableType;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.http.converter.MultipartAwareFormHttpMessageConverter;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerMapping;

public abstract class HttpRequestHandlingEndpointSupport
extends BaseHttpInboundEndpoint {
    private final List<HttpMessageConverter<?>> defaultMessageConverters = new ArrayList();
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private boolean convertersMerged;
    private boolean mergeWithDefaultConverters = false;
    private MultipartResolver multipartResolver;

    public HttpRequestHandlingEndpointSupport() {
        this(true);
    }

    public HttpRequestHandlingEndpointSupport(boolean expectReply) {
        super(expectReply);
        this.defaultMessageConverters.add(new MultipartAwareFormHttpMessageConverter());
        this.defaultMessageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.defaultMessageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        this.defaultMessageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        SourceHttpMessageConverter sourceConverter = new SourceHttpMessageConverter();
        this.defaultMessageConverters.add((HttpMessageConverter<?>)sourceConverter);
        if (JAXB_PRESENT) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
            this.logger.debug((CharSequence)"'Jaxb2RootElementHttpMessageConverter' was added to the 'defaultMessageConverters'.");
        }
        if (JacksonPresent.isJackson2Present()) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
            this.logger.debug((CharSequence)"'MappingJackson2HttpMessageConverter' was added to the 'defaultMessageConverters'.");
        }
        if (ROME_TOOLS_PRESENT) {
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            this.defaultMessageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
            this.logger.debug((CharSequence)"'AtomFeedHttpMessageConverter' was added to the 'defaultMessageConverters'.");
            this.logger.debug((CharSequence)"'RssChannelHttpMessageConverter' was added to the 'defaultMessageConverters'.");
        }
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"'messageConverters' must not be null");
        Assert.noNullElements((Object[])messageConverters.toArray(), (String)"'messageConverters' must not contain null entries");
        ArrayList localConverters = new ArrayList(messageConverters);
        if (this.mergeWithDefaultConverters) {
            localConverters.addAll(this.defaultMessageConverters);
            this.convertersMerged = true;
        }
        this.messageConverters = localConverters;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        this.mergeWithDefaultConverters = mergeWithDefaultConverters;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    @Override
    protected void onInit() {
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.multipartResolver == null && beanFactory != null) {
            try {
                MultipartResolver resolver = (MultipartResolver)beanFactory.getBean("multipartResolver", MultipartResolver.class);
                this.logger.debug(() -> "Using MultipartResolver [" + String.valueOf(resolver) + "]");
                this.multipartResolver = resolver;
            }
            catch (NoSuchBeanDefinitionException e) {
                this.logger.debug(() -> "Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling will be supported.");
            }
        }
        if (this.messageConverters.size() == 0 || this.mergeWithDefaultConverters && !this.convertersMerged) {
            this.messageConverters.addAll(this.defaultMessageConverters);
        }
    }

    protected final Message<?> doHandleRequest(HttpServletRequest servletRequest, RequestEntity<?> httpEntity) {
        if (this.isRunning()) {
            return this.actualDoHandleRequest(servletRequest, httpEntity);
        }
        return this.createServiceUnavailableResponse();
    }

    /*
     * Exception decompiling
     */
    private Message<?> actualDoHandleRequest(HttpServletRequest servletRequest, RequestEntity<?> httpEntity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Message<?> prepareRequestMessage(HttpServletRequest servletRequest, RequestEntity<?> httpEntity, Map<String, Object> headers, Object payload) {
        AbstractIntegrationMessageBuilder messageBuilder;
        if (this.getValidator() != null) {
            this.validate(payload);
        }
        if (payload instanceof Message) {
            messageBuilder = this.getMessageBuilderFactory().fromMessage((Message)payload).copyHeadersIfAbsent(headers);
        } else {
            Assert.state((payload != null ? 1 : 0) != 0, (String)"payload cannot be null");
            messageBuilder = this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers);
        }
        HttpMethod method = httpEntity.getMethod();
        if (method != null) {
            messageBuilder.setHeader("http_requestMethod", (Object)method.toString());
        }
        return messageBuilder.setHeader("http_requestUrl", (Object)httpEntity.getUrl().toString()).setHeader("http_userPrincipal", (Object)servletRequest.getUserPrincipal()).build();
    }

    private StandardEvaluationContext prepareEvaluationContext(HttpServletRequest servletRequest, RequestEntity<?> httpEntity, MultiValueMap<String, String> requestParams) {
        Map matrixVariables;
        Map pathVariables;
        StandardEvaluationContext evaluationContext = this.createEvaluationContext();
        evaluationContext.setRootObject(httpEntity);
        evaluationContext.setVariable("requestAttributes", (Object)RequestContextHolder.currentRequestAttributes());
        evaluationContext.setVariable("requestParams", requestParams);
        evaluationContext.setVariable("requestHeaders", (Object)new ServletServerHttpRequest(servletRequest).getHeaders());
        Object[] requestCookies = servletRequest.getCookies();
        if (!ObjectUtils.isEmpty((Object[])requestCookies)) {
            LinkedMultiValueMap cookies = new LinkedMultiValueMap(requestCookies.length);
            for (Object requestCookie : requestCookies) {
                cookies.add((Object)requestCookie.getName(), requestCookie);
            }
            evaluationContext.setVariable("cookies", (Object)cookies);
        }
        if (!CollectionUtils.isEmpty((Map)(pathVariables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
            this.logger.debug(() -> "Mapped path variables: " + String.valueOf(pathVariables));
            evaluationContext.setVariable("pathVariables", (Object)pathVariables);
        }
        if (!CollectionUtils.isEmpty((Map)(matrixVariables = (Map)servletRequest.getAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE)))) {
            this.logger.debug(() -> "Mapped matrix variables: " + String.valueOf(matrixVariables));
            evaluationContext.setVariable("matrixVariables", (Object)matrixVariables);
        }
        return evaluationContext;
    }

    private Message<?> createServiceUnavailableResponse() {
        this.logger.debug(() -> "Endpoint is stopped; returning status " + String.valueOf(HttpStatus.SERVICE_UNAVAILABLE));
        return this.getMessageBuilderFactory().withPayload((Object)"Endpoint is stopped").setHeader("http_statusCode", (Object)HttpStatus.SERVICE_UNAVAILABLE).build();
    }

    protected final Object setupResponseAndConvertReply(ServletServerHttpResponse response, Message<?> replyMessage) {
        MessageHeaders replyMessageHeaders = replyMessage.getHeaders();
        this.getHeaderMapper().fromHeaders(replyMessageHeaders, (Object)response.getHeaders());
        HttpStatus httpStatus = this.resolveHttpStatusFromHeaders(replyMessageHeaders);
        if (httpStatus != null) {
            response.setStatusCode((HttpStatusCode)httpStatus);
        }
        Object reply = replyMessage;
        if (this.getExtractReplyPayload()) {
            reply = replyMessage.getPayload();
        }
        return reply;
    }

    protected void setStatusCodeIfNeeded(ServerHttpResponse response, HttpEntity<?> httpEntity) {
        HttpStatus httpStatus;
        if (this.getStatusCodeExpression() != null && (httpStatus = this.evaluateHttpStatus(httpEntity)) != null) {
            response.setStatusCode((HttpStatusCode)httpStatus);
        }
    }

    protected ServletServerHttpRequest prepareRequest(HttpServletRequest servletRequest) {
        if (servletRequest instanceof MultipartHttpServletRequest) {
            return new MultipartHttpInputMessage((MultipartHttpServletRequest)servletRequest);
        }
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(servletRequest)) {
            return new MultipartHttpInputMessage(this.multipartResolver.resolveMultipart(servletRequest));
        }
        return new ServletServerHttpRequest(servletRequest);
    }

    private void postProcessRequest(HttpServletRequest request) {
        if (this.multipartResolver != null && request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    private MultiValueMap<String, String> convertParameterMap(Map<String, String[]> parameterMap) {
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            for (String value : values = entry.getValue()) {
                convertedMap.add((Object)entry.getKey(), (Object)value);
            }
        }
        return convertedMap;
    }

    protected RequestEntity<Object> prepareRequestEntity(ServletServerHttpRequest request) throws IOException {
        Object requestBody = null;
        if (HttpRequestHandlingEndpointSupport.isReadable(request.getMethod())) {
            requestBody = this.extractRequestBody(request);
        }
        return new RequestEntity(requestBody, (MultiValueMap)request.getHeaders(), request.getMethod(), request.getURI());
    }

    protected Object extractRequestBody(ServletServerHttpRequest request) throws IOException {
        ResolvableType requestPayloadType;
        MediaType contentType = request.getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        if ((requestPayloadType = this.getRequestPayloadType()) == null) {
            requestPayloadType = ResolvableType.forClass("text".equals(contentType.getType()) ? String.class : byte[].class);
        }
        Type targetType = requestPayloadType.getType();
        Class targetClass = requestPayloadType.toClass();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            GenericHttpMessageConverter genericConverter;
            GenericHttpMessageConverter genericHttpMessageConverter = genericConverter = converter instanceof GenericHttpMessageConverter ? (GenericHttpMessageConverter)converter : null;
            if (!(genericConverter != null ? genericConverter.canRead(targetType, null, contentType) : converter.canRead(targetClass, contentType))) continue;
            if (genericConverter != null) {
                return genericConverter.read(targetType, null, (HttpInputMessage)request);
            }
            return converter.read(targetClass, (HttpInputMessage)request);
        }
        throw new MessagingException("Could not convert request: no suitable HttpMessageConverter found for expected type [" + String.valueOf(requestPayloadType) + "] and content type [" + String.valueOf(contentType) + "]");
    }
}

