/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.Message;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ClientModeCapable;
import org.springframework.integration.ip.tcp.connection.ClientModeConnectionManager;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.util.Assert;

public class TcpReceivingChannelAdapter
extends MessageProducerSupport
implements TcpListener,
ClientModeCapable,
OrderlyShutdownCapable {
    private AbstractConnectionFactory clientConnectionFactory;
    private AbstractConnectionFactory serverConnectionFactory;
    private volatile boolean isClientMode;
    private volatile long retryInterval = 60000L;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile ClientModeConnectionManager clientModeConnectionManager;
    private volatile boolean active;
    private volatile boolean shuttingDown;
    private final AtomicInteger activeCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMessage(Message<?> message) {
        if (this.shuttingDown) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Inbound message ignored; shutting down; " + message.toString()));
            }
        } else {
            if (message instanceof ErrorMessage) {
                return false;
            }
            this.activeCount.incrementAndGet();
            try {
                this.sendMessage(message);
            }
            finally {
                this.activeCount.decrementAndGet();
            }
        }
        return false;
    }

    protected void onInit() {
        super.onInit();
        if (this.isClientMode) {
            Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
            Assert.isTrue((!this.clientConnectionFactory.isSingleUse() ? 1 : 0) != 0, (String)"For client-mode, connection factory must have single-use='false'");
        }
    }

    protected void doStart() {
        super.doStart();
        if (!this.active) {
            this.active = true;
            this.shuttingDown = false;
            if (this.serverConnectionFactory != null) {
                this.serverConnectionFactory.start();
            }
            if (this.clientConnectionFactory != null) {
                this.clientConnectionFactory.start();
            }
            if (this.isClientMode) {
                ClientModeConnectionManager manager;
                this.clientModeConnectionManager = manager = new ClientModeConnectionManager(this.clientConnectionFactory);
                Assert.state((this.getTaskScheduler() != null ? 1 : 0) != 0, (String)"Client mode requires a task scheduler");
                this.scheduledFuture = this.getTaskScheduler().scheduleAtFixedRate((Runnable)manager, this.retryInterval);
            }
        }
    }

    protected void doStop() {
        super.doStop();
        if (this.active) {
            this.active = false;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            this.clientModeConnectionManager = null;
            if (this.clientConnectionFactory != null) {
                this.clientConnectionFactory.stop();
            }
            if (this.serverConnectionFactory != null) {
                this.serverConnectionFactory.stop();
            }
        }
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = connectionFactory;
        } else {
            this.serverConnectionFactory = connectionFactory;
        }
        connectionFactory.registerListener(this);
    }

    public boolean isListening() {
        if (this.serverConnectionFactory == null) {
            return false;
        }
        if (this.serverConnectionFactory instanceof AbstractServerConnectionFactory) {
            return ((AbstractServerConnectionFactory)this.serverConnectionFactory).isListening();
        }
        return false;
    }

    public String getComponentType() {
        return "ip:tcp-inbound-channel-adapter";
    }

    protected ConnectionFactory getClientConnectionFactory() {
        return this.clientConnectionFactory;
    }

    protected ConnectionFactory getServerConnectionFactory() {
        return this.serverConnectionFactory;
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    public void setClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isClientModeConnected() {
        if (this.isClientMode && this.clientModeConnectionManager != null) {
            return this.clientModeConnectionManager.isConnected();
        }
        return false;
    }

    @Override
    public void retryConnection() {
        if (this.active && this.isClientMode && this.clientModeConnectionManager != null) {
            this.clientModeConnectionManager.run();
        }
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return this.activeCount.get();
    }

    public int afterShutdown() {
        this.stop();
        return this.activeCount.get();
    }
}

