/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.springframework.context.Lifecycle;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class TcpOutboundGateway
extends AbstractReplyProducingMessageHandler
implements TcpSender,
TcpListener,
Lifecycle {
    private volatile AbstractClientConnectionFactory connectionFactory;
    private final Map<String, AsyncReply> pendingReplies = new ConcurrentHashMap<String, AsyncReply>();
    private final Semaphore semaphore = new Semaphore(1, true);
    private volatile long remoteTimeout = 10000L;
    private volatile boolean remoteTimeoutSet = false;
    private volatile long requestTimeout = 10000L;

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setRemoteTimeout(long remoteTimeout) {
        this.remoteTimeout = remoteTimeout;
        this.remoteTimeoutSet = true;
    }

    public void setSendTimeout(long sendTimeout) {
        super.setSendTimeout(sendTimeout);
        if (!this.remoteTimeoutSet) {
            this.remoteTimeout = sendTimeout;
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Message<?> message;
        boolean haveSemaphore;
        block17: {
            Assert.notNull((Object)this.connectionFactory, (String)(this.getClass().getName() + " requires a client connection factory"));
            haveSemaphore = false;
            String connectionId = null;
            try {
                boolean singleUseConnection = this.connectionFactory.isSingleUse();
                if (!singleUseConnection) {
                    this.logger.debug((Object)"trying semaphore");
                    if (!this.semaphore.tryAcquire(this.requestTimeout, TimeUnit.MILLISECONDS)) {
                        throw new MessageTimeoutException(requestMessage, "Timed out waiting for connection");
                    }
                    haveSemaphore = true;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"got semaphore");
                    }
                }
                TcpConnectionSupport connection = this.connectionFactory.getConnection();
                AsyncReply reply = new AsyncReply();
                connectionId = connection.getConnectionId();
                this.pendingReplies.put(connectionId, reply);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Added " + connection.getConnectionId()));
                }
                connection.send(requestMessage);
                Message<?> replyMessage = reply.getReply();
                if (replyMessage == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Remote Timeout on " + connection.getConnectionId()));
                    }
                    this.connectionFactory.forceClose(connection);
                    throw new MessageTimeoutException(requestMessage, "Timed out waiting for response");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Respose " + replyMessage));
                }
                message = replyMessage;
                if (connectionId == null) break block17;
                this.pendingReplies.remove(connectionId);
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)"Tcp Gateway exception", (Throwable)e);
                    if (e instanceof MessagingException) {
                        throw (MessagingException)e;
                    }
                    throw new MessagingException("Failed to send or receive", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (connectionId != null) {
                        this.pendingReplies.remove(connectionId);
                    }
                    if (haveSemaphore) {
                        this.semaphore.release();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"released semaphore");
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (haveSemaphore) {
            this.semaphore.release();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"released semaphore");
            }
        }
        return message;
    }

    @Override
    public boolean onMessage(Message<?> message) {
        AsyncReply reply;
        String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId");
        if (connectionId == null) {
            this.logger.error((Object)"Cannot correlate response - no connection id");
            return false;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("onMessage: " + connectionId + "(" + message + ")"));
        }
        if ((reply = this.pendingReplies.get(connectionId)) == null) {
            if (message instanceof ErrorMessage) {
                return false;
            }
            this.logger.error((Object)"Cannot correlate response - no pending reply");
            return false;
        }
        reply.setReply(message);
        return false;
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        Assert.isTrue((boolean)(connectionFactory instanceof AbstractClientConnectionFactory), (String)(this.getClass().getName() + " requires a client connection factory"));
        this.connectionFactory = (AbstractClientConnectionFactory)connectionFactory;
        connectionFactory.registerListener(this);
        connectionFactory.registerSender(this);
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public String getComponentType() {
        return "ip:tcp-outbound-gateway";
    }

    public void start() {
        this.connectionFactory.start();
    }

    public void stop() {
        this.connectionFactory.stop();
    }

    public boolean isRunning() {
        return this.connectionFactory.isRunning();
    }

    protected AbstractConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private class AsyncReply {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CountDownLatch secondChanceLatch = new CountDownLatch(1);
        private volatile Message<?> reply;

        public Message<?> getReply() throws Exception {
            try {
                if (!this.latch.await(TcpOutboundGateway.this.remoteTimeout, TimeUnit.MILLISECONDS)) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            boolean waitForMessageAfterError = true;
            while (this.reply instanceof ErrorMessage) {
                if (waitForMessageAfterError) {
                    TcpOutboundGateway.this.logger.debug((Object)"second chance");
                    this.secondChanceLatch.await(2L, TimeUnit.SECONDS);
                    waitForMessageAfterError = false;
                    continue;
                }
                if (this.reply.getPayload() instanceof MessagingException) {
                    throw (MessagingException)this.reply.getPayload();
                }
                throw new MessagingException("Exception while awaiting reply", (Throwable)this.reply.getPayload());
            }
            return this.reply;
        }

        public void setReply(Message<?> reply) {
            if (this.reply == null) {
                this.reply = reply;
                this.latch.countDown();
            } else if (this.reply instanceof ErrorMessage) {
                this.reply = reply;
                this.secondChanceLatch.countDown();
            }
        }
    }
}

