/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;

public class TcpMessageMapper
implements InboundMessageMapper<TcpConnection>,
OutboundMessageMapper<Object>,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String charset = "UTF-8";
    private volatile boolean stringToBytes = true;
    private volatile boolean applySequence = false;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;
    private BeanFactory beanFactory;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setStringToBytes(boolean stringToBytes) {
        this.stringToBytes = stringToBytes;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public Message<?> toMessage(TcpConnection connection) throws Exception {
        Message message = null;
        Object payload = connection.getPayload();
        if (payload != null) {
            AbstractIntegrationMessageBuilder messageBuilder = this.getMessageBuilderFactory().withPayload(payload);
            this.addStandardHeaders(connection, messageBuilder);
            this.addCustomHeaders(connection, messageBuilder);
            message = messageBuilder.build();
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Null payload from connection " + connection.getConnectionId()));
        }
        return message;
    }

    protected final void addStandardHeaders(TcpConnection connection, AbstractIntegrationMessageBuilder<?> messageBuilder) {
        SocketInfo socketInfo;
        String connectionId = connection.getConnectionId();
        messageBuilder.setHeader("ip_hostname", (Object)connection.getHostName()).setHeader("ip_address", (Object)connection.getHostAddress()).setHeader("ip_tcp_remotePort", (Object)connection.getPort()).setHeader("ip_connectionId", (Object)connectionId);
        if (connection instanceof TcpConnectionSupport && (socketInfo = ((TcpConnectionSupport)connection).getSocketInfo()) != null) {
            messageBuilder.setHeader("ip_localInetAddress", (Object)socketInfo.getLocalAddress());
        }
        if (this.applySequence) {
            messageBuilder.setCorrelationId((Object)connectionId).setSequenceNumber(Integer.valueOf((int)connection.incrementAndGetConnectionSequence()));
        }
    }

    protected final void addCustomHeaders(TcpConnection connection, AbstractIntegrationMessageBuilder<?> messageBuilder) {
        Map<String, ?> customHeaders = this.supplyCustomHeaders(connection);
        if (customHeaders != null) {
            messageBuilder.copyHeadersIfAbsent(customHeaders);
        }
    }

    protected Map<String, ?> supplyCustomHeaders(TcpConnection connection) {
        return null;
    }

    public Object fromMessage(Message<?> message) throws Exception {
        if (this.stringToBytes) {
            return this.getPayloadAsBytes(message);
        }
        return message.getPayload();
    }

    private byte[] getPayloadAsBytes(Message<?> message) {
        byte[] bytes = null;
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            bytes = (byte[])payload;
        } else if (payload instanceof String) {
            try {
                bytes = ((String)payload).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageHandlingException(message, (Throwable)e);
            }
        } else {
            throw new MessageHandlingException(message, "When using a byte array serializer, the socket mapper expects either a byte array or String payload, but received: " + payload.getClass());
        }
        return bytes;
    }
}

