/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class TcpNioSSLConnection
extends TcpNioConnection {
    private final SSLEngine sslEngine;
    private volatile ByteBuffer decoded;
    private volatile ByteBuffer encoded;
    private volatile SSLChannelOutputStream sslChannelOutputStream;
    private final Semaphore semaphore = new Semaphore(0);
    private final Object monitorLock = new Object();
    private volatile boolean writerActive;
    private boolean needMoreNetworkData;

    public TcpNioSSLConnection(SocketChannel socketChannel, boolean server, boolean lookupHost, ApplicationEventPublisher applicationEventPublisher, String connectionFactoryName, SSLEngine sslEngine) throws Exception {
        super(socketChannel, server, lookupHost, applicationEventPublisher, connectionFactoryName);
        this.sslEngine = sslEngine;
    }

    @Override
    public SSLSession getSslSession() {
        return this.sslEngine.getSession();
    }

    @Override
    protected void sendToPipe(ByteBuffer networkBuffer) throws IOException {
        Assert.notNull((Object)networkBuffer, (String)"rawBuffer cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sendToPipe " + (Object)((Object)this.sslEngine.getHandshakeStatus()) + ", remaining:" + networkBuffer.remaining()));
        }
        SSLEngineResult result = null;
        while (!this.needMoreNetworkData) {
            result = this.decode(networkBuffer);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("result " + this.resultToString(result) + ", remaining:" + networkBuffer.remaining()));
        }
        this.needMoreNetworkData = false;
        if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            networkBuffer.compact();
        } else {
            networkBuffer.clear();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sendToPipe.x " + this.resultToString(result) + ", remaining:" + networkBuffer.remaining()));
        }
    }

    private SSLEngineResult decode(ByteBuffer networkBuffer) throws IOException {
        SSLEngineResult result = new SSLEngineResult(SSLEngineResult.Status.OK, this.sslEngine.getHandshakeStatus(), 0, 0);
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        switch (handshakeStatus) {
            case NEED_TASK: {
                this.runTasks();
                break;
            }
            case NEED_UNWRAP: 
            case FINISHED: 
            case NOT_HANDSHAKING: {
                SSLEngineResult.Status status;
                this.decoded.clear();
                result = this.sslEngine.unwrap(networkBuffer, this.decoded);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("After unwrap:" + this.resultToString(result)));
                }
                if ((status = result.getStatus()) == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.decoded = this.allocateEncryptionBuffer(this.sslEngine.getSession().getApplicationBufferSize());
                }
                if (result.bytesProduced() <= 0) break;
                this.decoded.flip();
                super.sendToPipe(this.decoded);
                break;
            }
            case NEED_WRAP: {
                if (this.resumeWriterIfNeeded()) break;
                this.encoded.clear();
                result = this.sslEngine.wrap(networkBuffer, this.encoded);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("After wrap:" + this.resultToString(result)));
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.encoded = this.allocateEncryptionBuffer(this.sslEngine.getSession().getPacketBufferSize());
                    break;
                }
                this.encoded.flip();
                this.getSSLChannelOutputStream().writeEncoded(this.encoded);
                break;
            }
        }
        switch (result.getHandshakeStatus()) {
            case FINISHED: {
                this.resumeWriterIfNeeded();
            }
            case NEED_UNWRAP: 
            case NOT_HANDSHAKING: {
                this.needMoreNetworkData = result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW || networkBuffer.remaining() == 0;
                break;
            }
        }
        return result;
    }

    private boolean resumeWriterIfNeeded() {
        if (this.writerActive) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Waking sender, permits:" + this.semaphore.availablePermits()));
            }
            this.semaphore.release();
            return true;
        }
        return false;
    }

    private void runTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    private SSLEngineResult.HandshakeStatus runTasksIfNeeded(SSLEngineResult result) throws IOException {
        if (result != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Running tasks if needed " + this.resultToString(result)));
            }
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.runTasks();
            }
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("New handshake status " + (Object)((Object)handshakeStatus)));
        }
        return handshakeStatus;
    }

    public void init() throws IOException {
        if (this.decoded == null) {
            this.decoded = this.allocateEncryptionBuffer(2048);
            this.encoded = this.allocateEncryptionBuffer(2048);
            this.initilizeEngine();
        }
    }

    private ByteBuffer allocateEncryptionBuffer(int size) {
        if (this.isUsingDirectBuffers()) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    private void initilizeEngine() throws IOException {
        boolean client = !this.isServer();
        this.sslEngine.setUseClientMode(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TcpNioConnection.ChannelOutputStream getChannelOutputStream() {
        Object object = this.monitorLock;
        synchronized (object) {
            if (this.sslChannelOutputStream == null) {
                this.sslChannelOutputStream = new SSLChannelOutputStream(super.getChannelOutputStream());
            }
            return this.sslChannelOutputStream;
        }
    }

    protected SSLChannelOutputStream getSSLChannelOutputStream() {
        if (this.sslChannelOutputStream == null) {
            return (SSLChannelOutputStream)this.getChannelOutputStream();
        }
        return this.sslChannelOutputStream;
    }

    private String resultToString(SSLEngineResult result) {
        return result.toString().replace('\n', ' ');
    }

    class SSLChannelOutputStream
    extends TcpNioConnection.ChannelOutputStream {
        private final TcpNioConnection.ChannelOutputStream channelOutputStream;

        public SSLChannelOutputStream(TcpNioConnection.ChannelOutputStream channelOutputStream) {
            super(TcpNioSSLConnection.this);
            this.channelOutputStream = channelOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void doWrite(ByteBuffer plainText) throws IOException {
            try {
                TcpNioSSLConnection.this.writerActive = true;
                int remaining = plainText.remaining();
                while (remaining > 0) {
                    SSLEngineResult result = this.encode(plainText);
                    if (TcpNioSSLConnection.this.logger.isDebugEnabled()) {
                        TcpNioSSLConnection.this.logger.debug((Object)("doWrite: " + TcpNioSSLConnection.this.resultToString(result)));
                    }
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        this.writeEncodedIfAny();
                        if (plainText.remaining() >= remaining) {
                            throw new MessagingException("Unexpected condition - SSL wrap did not consume any data; remaining = " + remaining);
                        }
                        remaining = plainText.remaining();
                        continue;
                    }
                    this.doClientSideHandshake(plainText, result);
                    this.writeEncodedIfAny();
                }
            }
            finally {
                TcpNioSSLConnection.this.writerActive = false;
            }
        }

        private void doClientSideHandshake(ByteBuffer plainText, SSLEngineResult result) throws IOException, SSLException {
            TcpNioSSLConnection.this.semaphore.drainPermits();
            SSLEngineResult.HandshakeStatus status = TcpNioSSLConnection.this.sslEngine.getHandshakeStatus();
            while (status != SSLEngineResult.HandshakeStatus.FINISHED) {
                this.writeEncodedIfAny();
                status = TcpNioSSLConnection.this.runTasksIfNeeded(result);
                if (status == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    status = this.waitForHandshakeData(result, status);
                }
                if (status == SSLEngineResult.HandshakeStatus.NEED_WRAP || status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || status == SSLEngineResult.HandshakeStatus.FINISHED) {
                    result = this.encode(plainText);
                    status = result.getHandshakeStatus();
                    if (status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && status != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                    break;
                }
                TcpNioSSLConnection.this.logger.debug((Object)status);
            }
        }

        private void writeEncodedIfAny() throws IOException {
            TcpNioSSLConnection.this.encoded.flip();
            this.writeEncoded(TcpNioSSLConnection.this.encoded);
            TcpNioSSLConnection.this.encoded.clear();
        }

        private SSLEngineResult.HandshakeStatus waitForHandshakeData(SSLEngineResult result, SSLEngineResult.HandshakeStatus status) throws IOException {
            try {
                if (TcpNioSSLConnection.this.logger.isTraceEnabled()) {
                    TcpNioSSLConnection.this.logger.trace((Object)"Writer waiting for handshake");
                }
                if (!TcpNioSSLConnection.this.semaphore.tryAcquire(30L, TimeUnit.SECONDS)) {
                    throw new MessagingException("SSL Handshaking taking too long");
                }
                if (TcpNioSSLConnection.this.logger.isTraceEnabled()) {
                    TcpNioSSLConnection.this.logger.trace((Object)"Writer resuming handshake");
                }
                status = TcpNioSSLConnection.this.runTasksIfNeeded(result);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MessagingException("Interrupted during SSL Handshaking");
            }
            return status;
        }

        private SSLEngineResult encode(ByteBuffer plainText) throws SSLException, IOException {
            TcpNioSSLConnection.this.encoded.clear();
            SSLEngineResult result = TcpNioSSLConnection.this.sslEngine.wrap(plainText, TcpNioSSLConnection.this.encoded);
            if (TcpNioSSLConnection.this.logger.isDebugEnabled()) {
                TcpNioSSLConnection.this.logger.debug((Object)("After wrap:" + TcpNioSSLConnection.this.resultToString(result) + " Plaintext buffer @" + plainText.position() + "/" + plainText.limit()));
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                TcpNioSSLConnection.this.encoded = TcpNioSSLConnection.this.allocateEncryptionBuffer(TcpNioSSLConnection.this.sslEngine.getSession().getPacketBufferSize());
                result = TcpNioSSLConnection.this.sslEngine.wrap(plainText, TcpNioSSLConnection.this.encoded);
            }
            return result;
        }

        void writeEncoded(ByteBuffer encoded) throws IOException {
            this.channelOutputStream.doWrite(encoded);
        }
    }
}

