/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.integration.ip.AbstractInternetProtocolReceivingChannelAdapter;
import org.springframework.integration.ip.udp.DatagramPacketMessageMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;

public class UnicastReceivingChannelAdapter
extends AbstractInternetProtocolReceivingChannelAdapter {
    private volatile DatagramSocket socket;
    private final DatagramPacketMessageMapper mapper = new DatagramPacketMessageMapper();
    private volatile int soSendBufferSize = -1;
    private static Pattern addressPattern = Pattern.compile("([^:]*):([0-9]*)");

    public UnicastReceivingChannelAdapter(int port) {
        super(port);
        this.mapper.setLengthCheck(false);
    }

    public UnicastReceivingChannelAdapter(int port, boolean lengthCheck) {
        super(port);
        this.mapper.setLengthCheck(lengthCheck);
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    public int getPort() {
        if (this.socket == null) {
            return super.getPort();
        }
        return this.socket.getLocalPort();
    }

    protected void onInit() {
        super.onInit();
        this.mapper.setBeanFactory(this.getBeanFactory());
    }

    public void run() {
        this.getSocket();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("UDP Receiver running on port:" + this.getPort()));
        }
        this.setListening(true);
        while (this.isActive()) {
            try {
                this.asyncSendMessage(this.receive());
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException e) {
                this.stop();
            }
            catch (Exception e) {
                if (e instanceof MessagingException) {
                    throw (MessagingException)e;
                }
                throw new MessagingException("failed to receive DatagramPacket", (Throwable)e);
            }
        }
        this.setListening(false);
    }

    protected void sendAck(Message<byte[]> message) {
        MessageHeaders headers = message.getHeaders();
        Object id = headers.get((Object)"ip_ackId");
        byte[] ack = id.toString().getBytes();
        String ackAddress = ((String)headers.get((Object)"ip_ackTo")).trim();
        Matcher mat = addressPattern.matcher(ackAddress);
        if (!mat.matches()) {
            throw new MessagingException(message, "Ack requested but could not decode acknowledgment address: " + ackAddress);
        }
        String host = mat.group(1);
        int port = Integer.parseInt(mat.group(2));
        InetSocketAddress whereTo = new InetSocketAddress(host, port);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending ack for " + id + " to " + ackAddress));
        }
        try {
            DatagramPacket ackPack = new DatagramPacket(ack, ack.length, whereTo);
            DatagramSocket out = new DatagramSocket();
            if (this.soSendBufferSize > 0) {
                out.setSendBufferSize(this.soSendBufferSize);
            }
            out.send(ackPack);
            out.close();
        }
        catch (IOException e) {
            throw new MessagingException(message, "Failed to send acknowledgment to: " + ackAddress, (Throwable)e);
        }
    }

    protected boolean asyncSendMessage(final DatagramPacket packet) {
        Executor taskExecutor = this.getTaskExecutor();
        if (taskExecutor != null) {
            try {
                taskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        UnicastReceivingChannelAdapter.this.doSend(packet);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Adapter stopped, sending on main thread");
                }
                this.doSend(packet);
            }
        }
        return true;
    }

    protected void doSend(DatagramPacket packet) {
        Message<byte[]> message = null;
        try {
            message = this.mapper.toMessage(packet);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received:" + message));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to map packet to message ", (Throwable)e);
        }
        if (message != null) {
            if (message.getHeaders().containsKey((Object)"ip_ackTo")) {
                this.sendAck(message);
            }
            this.sendMessage(message);
        }
    }

    protected DatagramPacket receive() throws Exception {
        DatagramSocket socket = this.getSocket();
        byte[] buffer = new byte[this.getReceiveBufferSize()];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        socket.receive(packet);
        return packet;
    }

    public void setSocket(DatagramSocket socket) {
        this.socket = socket;
    }

    protected DatagramSocket getTheSocket() {
        return this.socket;
    }

    public synchronized DatagramSocket getSocket() {
        if (this.socket == null) {
            try {
                DatagramSocket socket = null;
                String localAddress = this.getLocalAddress();
                int port = super.getPort();
                if (localAddress == null) {
                    socket = port == 0 ? new DatagramSocket() : new DatagramSocket(port);
                } else {
                    InetAddress whichNic = InetAddress.getByName(localAddress);
                    socket = new DatagramSocket(new InetSocketAddress(whichNic, port));
                }
                this.setSocketAttributes(socket);
                this.socket = socket;
            }
            catch (IOException e) {
                throw new MessagingException("failed to create DatagramSocket", (Throwable)e);
            }
        }
        return this.socket;
    }

    protected void setSocketAttributes(DatagramSocket socket) throws SocketException {
        socket.setSoTimeout(this.getSoTimeout());
        int soReceiveBufferSize = this.getSoReceiveBufferSize();
        if (soReceiveBufferSize > 0) {
            socket.setReceiveBufferSize(soReceiveBufferSize);
        }
    }

    @Override
    protected void doStop() {
        super.doStop();
        try {
            DatagramSocket socket = this.socket;
            this.socket = null;
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public void setLookupHost(boolean lookupHost) {
        this.mapper.setLookupHost(lookupHost);
    }

    public String getComponentType() {
        return "ip:udp-inbound-channel-adapter";
    }
}

