/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import java.time.Duration;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionFailedEvent;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.lang.Nullable;

public abstract class AbstractClientConnectionFactory
extends AbstractConnectionFactory {
    private static final long DEFAULT_CONNECT_TIMEOUT = 60L;
    private final ReadWriteLock theConnectionLock = new ReentrantReadWriteLock();
    private boolean manualListenerRegistration;
    private Duration connectTimeout = Duration.ofSeconds(60L);
    private volatile TcpConnectionSupport theConnection;

    public AbstractClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = Duration.ofSeconds(connectTimeout);
    }

    protected Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void enableManualListenerRegistration() {
        this.manualListenerRegistration = true;
    }

    @Override
    public TcpConnectionSupport getConnection() throws InterruptedException {
        this.checkActive();
        return this.obtainConnection();
    }

    protected TcpConnectionSupport obtainConnection() throws InterruptedException {
        TcpConnectionSupport connection;
        if (!this.isSingleUse() && (connection = this.obtainSharedConnection()) != null) {
            return connection;
        }
        return this.obtainNewConnection();
    }

    @Nullable
    protected final TcpConnectionSupport obtainSharedConnection() throws InterruptedException {
        this.theConnectionLock.readLock().lockInterruptibly();
        try {
            TcpConnectionSupport connection = this.getTheConnection();
            if (connection != null && connection.isOpen()) {
                TcpConnectionSupport tcpConnectionSupport = connection;
                return tcpConnectionSupport;
            }
        }
        finally {
            this.theConnectionLock.readLock().unlock();
        }
        return null;
    }

    protected final TcpConnectionSupport obtainNewConnection() throws InterruptedException {
        boolean singleUse = this.isSingleUse();
        if (!singleUse) {
            this.theConnectionLock.writeLock().lockInterruptibly();
        }
        try {
            TcpConnectionSupport connection;
            if (!singleUse && (connection = this.obtainSharedConnection()) != null) {
                TcpConnectionSupport tcpConnectionSupport = connection;
                return tcpConnectionSupport;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Opening new socket connection to " + this.getHost() + ":" + this.getPort()));
            }
            connection = this.buildNewConnection();
            if (!singleUse) {
                this.setTheConnection(connection);
            }
            connection.publishConnectionOpenEvent();
            TcpConnectionSupport tcpConnectionSupport = connection;
            return tcpConnectionSupport;
        }
        catch (RuntimeException e) {
            ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
            if (applicationEventPublisher != null) {
                applicationEventPublisher.publishEvent((ApplicationEvent)new TcpConnectionFailedEvent(this, e));
            }
            throw e;
        }
        finally {
            if (!singleUse) {
                this.theConnectionLock.writeLock().unlock();
            }
        }
    }

    protected TcpConnectionSupport buildNewConnection() {
        throw new UnsupportedOperationException("Factories that don't override this class' obtainConnection() must implement this method");
    }

    protected void initializeConnection(TcpConnectionSupport connection, Socket socket) {
        if (this.manualListenerRegistration) {
            connection.enableManualListenerRegistration();
        } else {
            TcpListener listener = this.getListener();
            if (listener != null) {
                connection.registerListener(listener);
            }
        }
        TcpSender sender = this.getSender();
        if (sender != null) {
            connection.registerSender(sender);
        }
        connection.setMapper(this.getMapper());
        connection.setDeserializer(this.getDeserializer());
        connection.setSerializer(this.getSerializer());
    }

    protected void setTheConnection(TcpConnectionSupport theConnection) {
        this.theConnection = theConnection;
    }

    protected TcpConnectionSupport getTheConnection() {
        return this.theConnection;
    }

    public void forceClose(TcpConnection connection) {
        if (this.theConnection == connection) {
            this.theConnection = null;
        }
        connection.close();
    }
}

