/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.DefaultTcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioSSLConnection;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class TcpNioClientConnectionFactory
extends AbstractClientConnectionFactory
implements SchedulingAwareRunnable {
    private final Map<SocketChannel, TcpNioConnection> channelMap = new ConcurrentHashMap<SocketChannel, TcpNioConnection>();
    private final BlockingQueue<SocketChannel> newChannels = new LinkedBlockingQueue<SocketChannel>();
    private boolean usingDirectBuffers;
    private TcpNioConnectionSupport tcpNioConnectionSupport = new DefaultTcpNioConnectionSupport();
    private volatile Selector selector;

    public TcpNioClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    @Override
    protected void checkActive() {
        super.checkActive();
        int n = 0;
        while (this.selector == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (n++ <= 600) continue;
            throw new UncheckedIOException(new IOException("Factory failed to start"));
        }
    }

    @Override
    protected TcpConnectionSupport buildNewConnection() {
        try {
            TcpConnectionSupport wrappedConnection;
            SocketChannel socketChannel = SocketChannel.open();
            this.setSocketAttributes(socketChannel.socket());
            this.connect(socketChannel);
            TcpNioConnection connection = this.tcpNioConnectionSupport.createNewConnection(socketChannel, false, this.isLookupHost(), this.getApplicationEventPublisher(), this.getComponentName());
            connection.setUsingDirectBuffers(this.usingDirectBuffers);
            connection.setTaskExecutor(this.getTaskExecutor());
            Integer sslHandshakeTimeout = this.getSslHandshakeTimeout();
            if (sslHandshakeTimeout != null && connection instanceof TcpNioSSLConnection) {
                ((TcpNioSSLConnection)connection).setHandshakeTimeout(sslHandshakeTimeout);
            }
            if (!(wrappedConnection = this.wrapConnection(connection)).equals(connection)) {
                connection.setSenders(this.getSenders());
            }
            this.initializeConnection(wrappedConnection, socketChannel.socket());
            if (this.getSoTimeout() > 0) {
                connection.setLastRead(System.currentTimeMillis());
            }
            this.channelMap.put(socketChannel, connection);
            wrappedConnection.publishConnectionOpenEvent();
            this.newChannels.add(socketChannel);
            this.selector.wakeup();
            return wrappedConnection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException(e));
        }
    }

    private void connect(SocketChannel socketChannel) throws IOException, InterruptedException {
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(this.getHost(), this.getPort()));
        boolean connected = socketChannel.finishConnect();
        for (long timeLeft = this.getConnectTimeout().toMillis(); !connected && timeLeft > 0L; timeLeft -= 5L) {
            Thread.sleep(5L);
            connected = socketChannel.finishConnect();
        }
        if (!connected) {
            throw new IOException("Not connected after connectTimeout");
        }
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }

    public void setTcpNioConnectionSupport(TcpNioConnectionSupport tcpNioSupport) {
        Assert.notNull((Object)tcpNioSupport, (String)"TcpNioSupport must not be null");
        this.tcpNioConnectionSupport = tcpNioSupport;
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    public void stop() {
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Error closing selector");
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isActive()) {
                this.setActive(true);
                this.getTaskExecutor().execute((Runnable)((Object)this));
            }
        }
        super.start();
    }

    public void run() {
        this.logger.debug(() -> "Read selector running for connections to " + this.getHost() + ':' + this.getPort());
        try {
            this.selector = Selector.open();
            while (this.isActive()) {
                this.processSelectorWhileActive();
            }
        }
        catch (ClosedSelectorException cse) {
            if (this.isActive()) {
                this.logger.error((Throwable)cse, (CharSequence)"Selector closed");
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (CharSequence)"Exception in read selector thread");
            this.setActive(false);
        }
        this.logger.debug(() -> "Read selector exiting for connections to " + this.getHost() + ':' + this.getPort());
    }

    private void processSelectorWhileActive() throws IOException {
        SocketChannel newChannel;
        int soTimeout = this.getSoTimeout();
        int selectionCount = 0;
        try {
            long timeout = Math.max(soTimeout, 0);
            if (this.getDelayedReads().size() > 0 && (timeout == 0L || this.getReadDelay() < timeout)) {
                timeout = this.getReadDelay();
            }
            selectionCount = this.selector.select(timeout);
        }
        catch (CancelledKeyException cke) {
            this.logger.debug((CharSequence)"CancelledKeyException during Selector.select()");
        }
        while ((newChannel = (SocketChannel)this.newChannels.poll()) != null) {
            try {
                newChannel.register(this.selector, 1, this.channelMap.get(newChannel));
            }
            catch (ClosedChannelException cce) {
                this.logger.debug((CharSequence)"Channel closed before registering with selector for reading");
            }
        }
        this.processNioSelections(selectionCount, this.selector, null, this.channelMap);
    }

    protected boolean isUsingDirectBuffers() {
        return this.usingDirectBuffers;
    }

    protected Map<SocketChannel, TcpNioConnection> getConnections() {
        return this.channelMap;
    }

    protected BlockingQueue<SocketChannel> getNewChannels() {
        return this.newChannels;
    }
}

