/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Queue;
import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.amqp.AmqpMessageChannelSpec;
import org.springframework.integration.dsl.amqp.AmqpPollableMessageChannelSpec;
import org.springframework.integration.dsl.amqp.AmqpPublishSubscribeMessageChannelSpec;
import org.springframework.integration.dsl.channel.DirectChannelSpec;
import org.springframework.integration.dsl.channel.ExecutorChannelSpec;
import org.springframework.integration.dsl.channel.MessageChannels;
import org.springframework.integration.dsl.channel.PriorityChannelSpec;
import org.springframework.integration.dsl.channel.PublishSubscribeChannelSpec;
import org.springframework.integration.dsl.channel.QueueChannelSpec;
import org.springframework.integration.dsl.channel.RendezvousChannelSpec;
import org.springframework.integration.dsl.jms.Jms;
import org.springframework.integration.dsl.jms.JmsMessageChannelSpec;
import org.springframework.integration.dsl.jms.JmsPollableMessageChannelSpec;
import org.springframework.integration.dsl.jms.JmsPublishSubscribeMessageChannelSpec;
import org.springframework.integration.store.ChannelMessageStore;
import org.springframework.integration.store.PriorityCapableChannelMessageStore;
import org.springframework.messaging.Message;

public class Channels {
    public DirectChannelSpec direct() {
        return MessageChannels.direct();
    }

    public DirectChannelSpec direct(String id) {
        return MessageChannels.direct(id);
    }

    public QueueChannelSpec queue() {
        return MessageChannels.queue();
    }

    public QueueChannelSpec queue(String id) {
        return MessageChannels.queue(id);
    }

    public QueueChannelSpec queue(Integer capacity) {
        return MessageChannels.queue(capacity);
    }

    public QueueChannelSpec queue(String id, Integer capacity) {
        return MessageChannels.queue(id, capacity);
    }

    public QueueChannelSpec queue(Queue<Message<?>> queue) {
        return MessageChannels.queue(queue);
    }

    public QueueChannelSpec queue(String id, Queue<Message<?>> queue) {
        return MessageChannels.queue(id, queue);
    }

    public QueueChannelSpec.MessageStoreSpec queue(ChannelMessageStore messageGroupStore, Object groupId) {
        return MessageChannels.queue(messageGroupStore, groupId);
    }

    public QueueChannelSpec.MessageStoreSpec queue(String id, ChannelMessageStore messageGroupStore, Object groupId) {
        return MessageChannels.queue(id, messageGroupStore, groupId);
    }

    public PriorityChannelSpec priority() {
        return MessageChannels.priority();
    }

    public PriorityChannelSpec priority(String id) {
        return MessageChannels.priority(id);
    }

    public QueueChannelSpec.MessageStoreSpec priority(String id, PriorityCapableChannelMessageStore messageGroupStore, Object groupId) {
        return MessageChannels.priority(id, messageGroupStore, groupId);
    }

    public QueueChannelSpec.MessageStoreSpec priority(PriorityCapableChannelMessageStore messageGroupStore, Object groupId) {
        return MessageChannels.priority(messageGroupStore, groupId);
    }

    public RendezvousChannelSpec rendezvous() {
        return MessageChannels.rendezvous();
    }

    public RendezvousChannelSpec rendezvous(String id) {
        return MessageChannels.rendezvous(id);
    }

    public PublishSubscribeChannelSpec<? extends PublishSubscribeChannelSpec<?>> publishSubscribe() {
        return MessageChannels.publishSubscribe();
    }

    public PublishSubscribeChannelSpec<? extends PublishSubscribeChannelSpec<?>> publishSubscribe(Executor executor) {
        return MessageChannels.publishSubscribe(executor);
    }

    public PublishSubscribeChannelSpec<? extends PublishSubscribeChannelSpec<?>> publishSubscribe(String id, Executor executor) {
        return MessageChannels.publishSubscribe(id, executor);
    }

    public PublishSubscribeChannelSpec<? extends PublishSubscribeChannelSpec<?>> publishSubscribe(String id) {
        return MessageChannels.publishSubscribe(id);
    }

    public ExecutorChannelSpec executor(Executor executor) {
        return MessageChannels.executor(executor);
    }

    public ExecutorChannelSpec executor(String id, Executor executor) {
        return MessageChannels.executor(id, executor);
    }

    public AmqpPollableMessageChannelSpec<? extends AmqpPollableMessageChannelSpec<?>> amqpPollable(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return Amqp.pollableChannel(connectionFactory);
    }

    public AmqpPollableMessageChannelSpec<? extends AmqpPollableMessageChannelSpec<?>> amqpPollable(String id, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return Amqp.pollableChannel(id, connectionFactory);
    }

    public AmqpMessageChannelSpec<? extends AmqpMessageChannelSpec<?>> amqp(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return Amqp.channel(connectionFactory);
    }

    public AmqpMessageChannelSpec<? extends AmqpMessageChannelSpec<?>> amqp(String id, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return Amqp.channel(id, connectionFactory);
    }

    public static AmqpPublishSubscribeMessageChannelSpec amqpPublishSubscribe(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return Amqp.publishSubscribeChannel(connectionFactory);
    }

    public static AmqpPublishSubscribeMessageChannelSpec amqpPublishSubscribe(String id, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return Amqp.publishSubscribeChannel(id, connectionFactory);
    }

    public JmsPollableMessageChannelSpec<? extends JmsPollableMessageChannelSpec<?>> jmsPollable(ConnectionFactory connectionFactory) {
        return Jms.pollableChannel(connectionFactory);
    }

    public JmsPollableMessageChannelSpec<? extends JmsPollableMessageChannelSpec<?>> jmsPollable(String id, ConnectionFactory connectionFactory) {
        return Jms.pollableChannel(id, connectionFactory);
    }

    public JmsMessageChannelSpec<? extends JmsMessageChannelSpec<?>> jms(ConnectionFactory connectionFactory) {
        return Jms.channel(connectionFactory);
    }

    public JmsMessageChannelSpec<? extends JmsMessageChannelSpec<?>> jms(String id, ConnectionFactory connectionFactory) {
        return Jms.channel(id, connectionFactory);
    }

    public JmsPublishSubscribeMessageChannelSpec jmsPublishSubscribe(ConnectionFactory connectionFactory) {
        return Jms.publishSubscribeChannel(connectionFactory);
    }

    public JmsPublishSubscribeMessageChannelSpec jmsPublishSubscribe(String id, ConnectionFactory connectionFactory) {
        return Jms.publishSubscribeChannel(id, connectionFactory);
    }

    Channels() {
    }
}

