/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.amqp.AmqpBaseInboundGatewaySpec;
import org.springframework.integration.dsl.amqp.AmqpInboundGatewaySpec;
import org.springframework.integration.dsl.http.Http;
import org.springframework.integration.dsl.http.HttpControllerEndpointSpec;
import org.springframework.integration.dsl.http.HttpRequestHandlerEndpointSpec;
import org.springframework.integration.dsl.jms.Jms;
import org.springframework.integration.dsl.jms.JmsInboundGatewaySpec;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class MessagingGateways {
    public AmqpInboundGatewaySpec amqp(ConnectionFactory connectionFactory, String ... queueNames) {
        return Amqp.inboundGateway(connectionFactory, queueNames);
    }

    public AmqpInboundGatewaySpec amqp(ConnectionFactory connectionFactory, Queue ... queues) {
        return Amqp.inboundGateway(connectionFactory, queues);
    }

    public AmqpBaseInboundGatewaySpec<?> amqp(SimpleMessageListenerContainer listenerContainer) {
        return Amqp.inboundGateway(listenerContainer);
    }

    public AmqpInboundGatewaySpec amqp(ConnectionFactory connectionFactory, AmqpTemplate amqpTemplate, String ... queueNames) {
        return Amqp.inboundGateway(connectionFactory, amqpTemplate, queueNames);
    }

    public AmqpInboundGatewaySpec amqp(ConnectionFactory connectionFactory, AmqpTemplate amqpTemplate, Queue ... queues) {
        return Amqp.inboundGateway(connectionFactory, amqpTemplate, queues);
    }

    public AmqpBaseInboundGatewaySpec<?> amqp(SimpleMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate) {
        return Amqp.inboundGateway(listenerContainer, amqpTemplate);
    }

    public JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<DefaultMessageListenerContainer> jms(javax.jms.ConnectionFactory connectionFactory) {
        return Jms.inboundGateway(connectionFactory);
    }

    public <C extends AbstractMessageListenerContainer> JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<C> jms(javax.jms.ConnectionFactory connectionFactory, Class<C> containerClass) {
        return Jms.inboundGateway(connectionFactory, containerClass);
    }

    public JmsInboundGatewaySpec<? extends JmsInboundGatewaySpec<?>> jms(AbstractMessageListenerContainer listenerContainer) {
        return Jms.inboundGateway(listenerContainer);
    }

    public HttpControllerEndpointSpec http(String viewName, String ... path) {
        return Http.inboundControllerGateway(viewName, path);
    }

    public HttpControllerEndpointSpec http(Expression viewExpression, String ... path) {
        return Http.inboundControllerGateway(viewExpression, path);
    }

    public HttpRequestHandlerEndpointSpec httpGateway(String ... path) {
        return Http.inboundGateway(path);
    }

    MessagingGateways() {
    }
}

