/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class RemoteFileOutboundGatewaySpec<F, S extends RemoteFileOutboundGatewaySpec<F, S>>
extends MessageHandlerSpec<S, AbstractRemoteFileOutboundGateway<F>> {
    private CompositeFileListFilter<F> filter;
    private CompositeFileListFilter<File> mputFilter;

    protected RemoteFileOutboundGatewaySpec(AbstractRemoteFileOutboundGateway<F> outboundGateway) {
        this.target = outboundGateway;
        ((AbstractRemoteFileOutboundGateway)this.target).setRequiresReply(true);
    }

    public S options(String options) {
        ((AbstractRemoteFileOutboundGateway)this.target).setOptions(options);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S options(AbstractRemoteFileOutboundGateway.Option ... options) {
        Assert.noNullElements((Object[])options);
        StringBuilder optionsString = new StringBuilder();
        for (AbstractRemoteFileOutboundGateway.Option option : options) {
            optionsString.append(option.getOption()).append(" ");
        }
        ((AbstractRemoteFileOutboundGateway)this.target).setOptions(optionsString.toString());
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        ((AbstractRemoteFileOutboundGateway)this.target).setRemoteFileSeparator(remoteFileSeparator);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S localDirectory(File localDirectory) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalDirectory(localDirectory);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S localDirectoryExpression(String localDirectoryExpression) {
        return this.localDirectoryExpression(PARSER.parseExpression(localDirectoryExpression));
    }

    public <P> S localDirectory(Function<Message<P>, String> localDirectoryFunction) {
        return this.localDirectoryExpression(new FunctionExpression<Message<P>>(localDirectoryFunction));
    }

    public S localDirectoryExpression(Expression localDirectoryExpression) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalDirectoryExpression(localDirectoryExpression);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S autoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        ((AbstractRemoteFileOutboundGateway)this.target).setAutoCreateLocalDirectory(autoCreateLocalDirectory);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        ((AbstractRemoteFileOutboundGateway)this.target).setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S filter(FileListFilter<F> filter) {
        if (this.filter == null) {
            if (filter instanceof CompositeFileListFilter) {
                this.filter = (CompositeFileListFilter)filter;
            } else {
                this.filter = new CompositeFileListFilter();
                this.filter.addFilter(filter);
            }
            ((AbstractRemoteFileOutboundGateway)this.target).setFilter(this.filter);
        } else {
            this.filter.addFilter(filter);
        }
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public abstract S patternFileNameFilter(String var1);

    public abstract S regexFileNameFilter(String var1);

    public S mputFilter(FileListFilter<File> filter) {
        if (this.mputFilter == null) {
            if (filter instanceof CompositeFileListFilter) {
                this.mputFilter = (CompositeFileListFilter)filter;
            } else {
                this.mputFilter = new CompositeFileListFilter();
                this.mputFilter.addFilter(filter);
            }
            ((AbstractRemoteFileOutboundGateway)this.target).setMputFilter(this.mputFilter);
        } else {
            this.mputFilter.addFilter(filter);
        }
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S patternMputFilter(String pattern) {
        return this.mputFilter((FileListFilter<File>)new SimplePatternFileListFilter(pattern));
    }

    public S regexMpuFilter(String regex) {
        return this.mputFilter((FileListFilter<File>)new RegexPatternFileListFilter(regex));
    }

    public S renameExpression(String expression) {
        ((AbstractRemoteFileOutboundGateway)this.target).setExpressionRename(PARSER.parseExpression(expression));
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    public S localFilenameExpression(String localFilenameExpression) {
        return this.localFilenameExpression(PARSER.parseExpression(localFilenameExpression));
    }

    public <P> S localFilename(Function<Message<P>, String> localFilenameFunction) {
        return this.localFilenameExpression(new FunctionExpression<Message<P>>(localFilenameFunction));
    }

    public S localFilenameExpression(Expression localFilenameExpression) {
        ((AbstractRemoteFileOutboundGateway)this.target).setLocalFilenameGeneratorExpression(localFilenameExpression);
        return (S)((RemoteFileOutboundGatewaySpec)this._this());
    }

    @Override
    protected AbstractRemoteFileOutboundGateway<F> doGet() {
        throw new UnsupportedOperationException();
    }
}

