/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.io.File;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.amqp.AmqpBaseInboundChannelAdapterSpec;
import org.springframework.integration.dsl.amqp.AmqpInboundChannelAdapterSpec;
import org.springframework.integration.dsl.file.Files;
import org.springframework.integration.dsl.file.TailAdapterSpec;
import org.springframework.integration.dsl.http.Http;
import org.springframework.integration.dsl.http.HttpControllerEndpointSpec;
import org.springframework.integration.dsl.http.HttpRequestHandlerEndpointSpec;
import org.springframework.integration.dsl.jms.Jms;
import org.springframework.integration.dsl.jms.JmsMessageDrivenChannelAdapterSpec;
import org.springframework.integration.dsl.mail.ImapIdleChannelAdapterSpec;
import org.springframework.integration.dsl.mail.Mail;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public class MessageProducers {
    public AmqpInboundChannelAdapterSpec amqp(ConnectionFactory connectionFactory, String ... queueNames) {
        return Amqp.inboundAdapter(connectionFactory, queueNames);
    }

    public AmqpInboundChannelAdapterSpec amqp(ConnectionFactory connectionFactory, Queue ... queues) {
        return Amqp.inboundAdapter(connectionFactory, queues);
    }

    @Deprecated
    public AmqpBaseInboundChannelAdapterSpec<?> inboundAdapter(SimpleMessageListenerContainer listenerContainer) {
        return this.amqp(listenerContainer);
    }

    public AmqpBaseInboundChannelAdapterSpec<?> amqp(SimpleMessageListenerContainer listenerContainer) {
        return Amqp.inboundAdapter(listenerContainer);
    }

    public TailAdapterSpec tail(File file) {
        return Files.tailAdapter(file);
    }

    public ImapIdleChannelAdapterSpec imap(String url) {
        return Mail.imapIdleAdapter(url);
    }

    public JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> jms(AbstractMessageListenerContainer listenerContainer) {
        return Jms.messageDrivenChannelAdapter(listenerContainer);
    }

    public JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> jms(javax.jms.ConnectionFactory connectionFactory) {
        return Jms.messageDrivenChannelAdapter(connectionFactory);
    }

    public <C extends AbstractMessageListenerContainer> JmsMessageDrivenChannelAdapterSpec<? extends JmsMessageDrivenChannelAdapterSpec<?>> jms(javax.jms.ConnectionFactory connectionFactory, Class<C> containerClass) {
        return Jms.messageDrivenChannelAdapter(connectionFactory, containerClass);
    }

    public HttpControllerEndpointSpec http(String viewName, String ... path) {
        return Http.inboundControllerAdapter(viewName, path);
    }

    public HttpControllerEndpointSpec http(Expression viewExpression, String ... path) {
        return Http.inboundControllerAdapter(viewExpression, path);
    }

    public HttpRequestHandlerEndpointSpec httpChannelAdapter(String ... path) {
        return Http.inboundChannelAdapter(path);
    }

    MessageProducers() {
    }
}

