/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import javax.jms.Destination;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;
import org.springframework.integration.dsl.jms.JmsInboundGateway;
import org.springframework.integration.dsl.jms.JmsListenerContainerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public class JmsInboundGatewaySpec<S extends JmsInboundGatewaySpec<S>>
extends MessagingGatewaySpec<S, JmsInboundGateway> {
    JmsInboundGatewaySpec(AbstractMessageListenerContainer listenerContainer) {
        super(new JmsInboundGateway(listenerContainer, new ChannelPublishingJmsMessageListener()));
        ((JmsInboundGateway)((Object)this.target)).getListener().setExpectReply(true);
    }

    public S defaultReplyDestination(Destination defaultReplyDestination) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDefaultReplyDestination(defaultReplyDestination);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S defaultReplyQueueName(String destinationName) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDefaultReplyQueueName(destinationName);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S defaultReplyTopicName(String destinationName) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDefaultReplyTopicName(destinationName);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S replyTimeToLive(long replyTimeToLive) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyTimeToLive(replyTimeToLive);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S replyPriority(int replyPriority) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyPriority(replyPriority);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S replyDeliveryPersistent(boolean replyDeliveryPersistent) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyDeliveryPersistent(replyDeliveryPersistent);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S correlationKey(String correlationKey) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setCorrelationKey(correlationKey);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S explicitQosEnabledForReplies(boolean explicitQosEnabledForReplies) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setExplicitQosEnabledForReplies(explicitQosEnabledForReplies);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S destinationResolver(DestinationResolver destinationResolver) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDestinationResolver(destinationResolver);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S jmsMessageConverter(MessageConverter messageConverter) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setMessageConverter(messageConverter);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S setHeaderMapper(JmsHeaderMapper headerMapper) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setHeaderMapper(headerMapper);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S extractRequestPayload(boolean extractRequestPayload) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setExtractRequestPayload(extractRequestPayload);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public S extractReplyPayload(boolean extractReplyPayload) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setExtractReplyPayload(extractReplyPayload);
        return (S)((JmsInboundGatewaySpec)this._this());
    }

    public static class JmsInboundGatewayListenerContainerSpec<C extends AbstractMessageListenerContainer>
    extends JmsInboundGatewaySpec<JmsInboundGatewayListenerContainerSpec<C>> {
        private final JmsListenerContainerSpec<C> spec;

        JmsInboundGatewayListenerContainerSpec(JmsListenerContainerSpec<C> spec) {
            super((AbstractMessageListenerContainer)spec.get());
            this.spec = spec;
            ((AbstractMessageListenerContainer)this.spec.get()).setAutoStartup(false);
        }

        public JmsInboundGatewayListenerContainerSpec<C> destination(Destination destination) {
            this.spec.destination(destination);
            return (JmsInboundGatewayListenerContainerSpec)this._this();
        }

        public JmsInboundGatewayListenerContainerSpec<C> destination(String destinationName) {
            this.spec.destination(destinationName);
            return (JmsInboundGatewayListenerContainerSpec)this._this();
        }

        public JmsInboundGatewayListenerContainerSpec<C> configureListenerContainer(Consumer<JmsListenerContainerSpec<C>> configurer) {
            Assert.notNull(configurer);
            configurer.accept(this.spec);
            return (JmsInboundGatewayListenerContainerSpec)this._this();
        }
    }
}

