/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.support.tuple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.Assert;

public class Tuple
implements Iterable,
Serializable {
    private static final long serialVersionUID = 8777121214502020842L;
    protected final Object[] entries;
    protected final int size;

    public Tuple(Collection<Object> values) {
        Assert.notEmpty(values);
        this.entries = values.toArray();
        this.size = this.entries.length;
    }

    public Tuple(Object ... values) {
        this.entries = Arrays.copyOf(values, values.length);
        this.size = values.length;
    }

    public Object get(int index) {
        return this.size > 0 && this.size > index ? this.entries[index] : null;
    }

    public Object[] toArray() {
        return this.entries;
    }

    public int size() {
        return this.size;
    }

    public Iterator<?> iterator() {
        return Arrays.asList(this.entries).iterator();
    }

    public int hashCode() {
        if (this.size == 0) {
            return 0;
        }
        if (this.size == 1) {
            return this.entries[0].hashCode();
        }
        int hashCode = 1;
        for (Object entry : this.entries) {
            hashCode ^= entry.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple cast = (Tuple)o;
        if (this.size != cast.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.entries[i].equals(cast.entries[i])) continue;
            return false;
        }
        return true;
    }
}

