/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.config;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.dsl.config.IntegrationFlowBeanPostProcessor;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.util.Assert;

public class DslIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final String INTEGRATION_FLOW_BPP_BEAN_NAME = IntegrationFlowBeanPostProcessor.class.getName();

    public void initialize(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)configurableListableBeanFactory, (String)"To use Spring Integration Java DSL the 'beanFactory' has to be an instance of 'BeanDefinitionRegistry'. Consider using 'GenericApplicationContext' implementation.");
        this.checkSpecBeans(configurableListableBeanFactory);
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)configurableListableBeanFactory;
        if (!registry.containsBeanDefinition(INTEGRATION_FLOW_BPP_BEAN_NAME)) {
            registry.registerBeanDefinition(INTEGRATION_FLOW_BPP_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(IntegrationFlowBeanPostProcessor.class));
        }
    }

    private void checkSpecBeans(ConfigurableListableBeanFactory beanFactory) {
        List<String> specBeanNames = Arrays.asList(beanFactory.getBeanNamesForType(IntegrationComponentSpec.class, true, false));
        if (!specBeanNames.isEmpty()) {
            throw new BeanCreationException("'IntegrationComponentSpec' beans: '" + specBeanNames + "' must be populated to target objects via 'get()' method call. It is important for @Autowired injections.");
        }
    }
}

