/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class LambdaMessageProcessor
implements MessageProcessor<Object>,
BeanFactoryAware {
    private final Object target;
    private final Method method;
    private final TypeDescriptor payloadType;
    private final Class<?>[] parameterTypes;
    private ConversionService conversionService;

    LambdaMessageProcessor(Object target, Class<?> payloadType) {
        Assert.notNull((Object)target);
        this.target = target;
        final AtomicReference methodValue = new AtomicReference();
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                methodValue.set(method);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return !method.isBridge() && method.getDeclaringClass() != Object.class && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers());
            }
        });
        Assert.notNull(methodValue.get(), (String)"LambdaMessageProcessor is applicable for inline or lambda classes with single method - functional interface implementations.");
        this.method = (Method)methodValue.get();
        this.method.setAccessible(true);
        this.parameterTypes = this.method.getParameterTypes();
        this.payloadType = payloadType != null ? TypeDescriptor.valueOf(payloadType) : null;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ConversionService conversionService = IntegrationUtils.getConversionService((BeanFactory)beanFactory);
        if (conversionService == null) {
            conversionService = new DefaultConversionService();
        }
        this.conversionService = conversionService;
    }

    public Object processMessage(Message<?> message) {
        Object[] args = new Object[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class<?> parameterType = this.parameterTypes[i];
            if (Message.class.isAssignableFrom(parameterType)) {
                args[i] = message;
            }
            if (Map.class.isAssignableFrom(parameterType)) {
                if (message.getPayload() instanceof Map) {
                    args[i] = message.getPayload();
                    continue;
                }
                args[i] = message.getHeaders();
                continue;
            }
            if (this.payloadType != null) {
                if (Message.class.isAssignableFrom(this.payloadType.getType())) {
                    args[i] = message;
                    continue;
                }
                args[i] = this.conversionService.convert(message.getPayload(), TypeDescriptor.forObject((Object)message.getPayload()), this.payloadType);
                continue;
            }
            args[i] = message.getPayload();
        }
        try {
            return this.method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            throw new MessageHandlingException(message, e.getCause());
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, (Throwable)e);
        }
    }
}

