/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.SourcePollingChannelAdapterFactoryBean;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.ConsumerEndpointSpec;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class IntegrationFlowBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
SmartInitializingSingleton {
    private final Set<ApplicationListener<?>> applicationListeners = new HashSet();
    private ConfigurableListableBeanFactory beanFactory;
    private AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"To use Spring Integration Java DSL the 'beanFactory' has to be an instance of 'ConfigurableListableBeanFactory'. Consider using 'GenericApplicationContext' implementation.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.autowiredAnnotationBeanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        this.autowiredAnnotationBeanPostProcessor.setBeanFactory((BeanFactory)this.beanFactory);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof StandardIntegrationFlow) {
            return this.processStandardIntegrationFlow((StandardIntegrationFlow)bean, beanName);
        }
        if (bean instanceof IntegrationFlow) {
            return this.processIntegrationFlowImpl((IntegrationFlow)bean, beanName);
        }
        if (bean instanceof IntegrationComponentSpec) {
            this.processIntegrationComponentSpec((IntegrationComponentSpec)bean);
        }
        return bean;
    }

    public void afterSingletonsInstantiated() {
        if (this.beanFactory.containsBean("applicationEventMulticaster")) {
            ApplicationEventMulticaster multicaster = (ApplicationEventMulticaster)this.beanFactory.getBean("applicationEventMulticaster");
            for (ApplicationListener<?> applicationListener : this.applicationListeners) {
                multicaster.addApplicationListener(applicationListener);
            }
        }
        for (String beanName : this.beanFactory.getBeanNamesForType(IntegrationFlow.class)) {
            String scope;
            if (!this.beanFactory.containsBeanDefinition(beanName) || !StringUtils.hasText((String)(scope = this.beanFactory.getBeanDefinition(beanName).getScope())) || "singleton".equals(scope)) continue;
            throw new BeanCreationNotAllowedException(beanName, "IntegrationFlows can not be scoped beans. Any dependant beans are registered as singletons, meanwhile IntegrationFlow is just a logical container for them. \nConsider to use [IntegrationFlowContext] for manual registration of IntegrationFlows.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object processStandardIntegrationFlow(StandardIntegrationFlow flow, String beanName) {
        String flowNamePrefix = beanName + ".";
        int subFlowNameIndex = 0;
        int channelNameIndex = 0;
        boolean registerSingleton = flow.isRegisterComponents();
        ArrayList<Object> integrationComponents = new ArrayList<Object>(flow.getIntegrationComponents());
        for (int i = 0; i < integrationComponents.size(); ++i) {
            String channelBeanName;
            Object component = integrationComponents.get(i);
            if (component instanceof ConsumerEndpointSpec) {
                String endpointBeanName;
                ConsumerEndpointSpec endpointSpec = (ConsumerEndpointSpec)component;
                MessageHandler messageHandler = (MessageHandler)((Tuple2)endpointSpec.get()).getT2();
                ConsumerEndpointFactoryBean endpoint = (ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.get()).getT1();
                String id = endpointSpec.getId();
                Collection collection = this.beanFactory.getBeansOfType(messageHandler.getClass(), false, false).values();
                if (!collection.contains(messageHandler)) {
                    String[] stringArray;
                    String handlerBeanName = this.generateBeanName(messageHandler);
                    if (id != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = (String)id + ".handler";
                    } else {
                        stringArray = null;
                    }
                    String[] handlerAlias = stringArray;
                    this.registerComponent(messageHandler, handlerBeanName, beanName, registerSingleton);
                    if (handlerAlias != null) {
                        for (String alias : handlerAlias) {
                            this.beanFactory.registerAlias(handlerBeanName, alias);
                        }
                    }
                }
                if ((endpointBeanName = id) == null) {
                    endpointBeanName = this.generateBeanName(endpoint);
                }
                this.registerComponent(endpoint, endpointBeanName, beanName, registerSingleton);
                integrationComponents.set(i, endpoint);
                continue;
            }
            Collection values = this.beanFactory.getBeansOfType(component.getClass(), false, false).values();
            if (values.contains(component)) continue;
            if (component instanceof AbstractMessageChannel) {
                channelBeanName = ((AbstractMessageChannel)component).getComponentName();
                if (channelBeanName == null) {
                    channelBeanName = flowNamePrefix + "channel" + "#" + channelNameIndex++;
                }
                this.registerComponent(component, channelBeanName, beanName, registerSingleton);
                continue;
            }
            if (component instanceof MessageChannelReference) {
                channelBeanName = ((MessageChannelReference)component).getName();
                if (this.beanFactory.containsBean(channelBeanName)) continue;
                DirectChannel directChannel = new DirectChannel();
                this.registerComponent(directChannel, channelBeanName, beanName, registerSingleton);
                integrationComponents.set(i, directChannel);
                continue;
            }
            if (component instanceof FixedSubscriberChannel) {
                FixedSubscriberChannel fixedSubscriberChannel = (FixedSubscriberChannel)component;
                String channelBeanName2 = fixedSubscriberChannel.getComponentName();
                if ("Unnamed fixed subscriber channel".equals(channelBeanName2)) {
                    channelBeanName2 = flowNamePrefix + "channel" + "#" + channelNameIndex++;
                }
                this.registerComponent(component, channelBeanName2, beanName, registerSingleton);
                continue;
            }
            if (component instanceof SourcePollingChannelAdapterSpec) {
                void var14_20;
                SourcePollingChannelAdapterSpec spec = (SourcePollingChannelAdapterSpec)component;
                Collection<Object> componentsToRegister = spec.getComponentsToRegister();
                if (!CollectionUtils.isEmpty(componentsToRegister)) {
                    for (Object e : componentsToRegister) {
                        if (this.beanFactory.getBeansOfType(e.getClass(), false, false).values().contains(e)) continue;
                        this.registerComponent(e, this.generateBeanName(e));
                    }
                }
                SourcePollingChannelAdapterFactoryBean pollingChannelAdapterFactoryBean = (SourcePollingChannelAdapterFactoryBean)((Tuple2)spec.get()).getT1();
                String string = spec.getId();
                if (!StringUtils.hasText((String)string)) {
                    String string2 = this.generateBeanName(pollingChannelAdapterFactoryBean);
                }
                this.registerComponent(pollingChannelAdapterFactoryBean, (String)var14_20, beanName, registerSingleton);
                integrationComponents.set(i, pollingChannelAdapterFactoryBean);
                MessageSource messageSource = (MessageSource)((Tuple2)spec.get()).getT2();
                if (this.beanFactory.getBeansOfType(messageSource.getClass(), false, false).values().contains(messageSource)) continue;
                String messageSourceId = (String)var14_20 + ".source";
                if (messageSource instanceof NamedComponent && ((NamedComponent)messageSource).getComponentName() != null) {
                    messageSourceId = ((NamedComponent)messageSource).getComponentName();
                }
                this.registerComponent(messageSource, messageSourceId, beanName, registerSingleton);
                continue;
            }
            if (component instanceof StandardIntegrationFlow) {
                String subFlowBeanName = flowNamePrefix + "subFlow" + "#" + subFlowNameIndex++;
                this.registerComponent(component, subFlowBeanName, beanName, registerSingleton);
                continue;
            }
            String generateBeanName = this.generateBeanName(component);
            this.registerComponent(component, generateBeanName, beanName, registerSingleton);
        }
        flow.setIntegrationComponents(integrationComponents);
        return flow;
    }

    private Object processIntegrationFlowImpl(IntegrationFlow flow, String beanName) {
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from(beanName + ".input");
        flow.configure(flowBuilder);
        Object standardIntegrationFlow = this.processStandardIntegrationFlow(flowBuilder.get(), beanName);
        return IntegrationFlowBeanPostProcessor.isLambda(flow) ? standardIntegrationFlow : flow;
    }

    private void processIntegrationComponentSpec(IntegrationComponentSpec<?, ?> bean) {
        Collection<Object> componentsToRegister;
        this.registerComponent(bean.get(), this.generateBeanName(bean.get()), null, false);
        if (bean instanceof ComponentsRegistration && !CollectionUtils.isEmpty(componentsToRegister = ((ComponentsRegistration)((Object)bean)).getComponentsToRegister())) {
            for (Object component : componentsToRegister) {
                if (this.beanFactory.getBeansOfType(component.getClass(), false, false).values().contains(component)) continue;
                this.registerComponent(component, this.generateBeanName(component));
            }
        }
    }

    private void registerComponent(Object component, String beanName) {
        this.registerComponent(component, beanName, null, true);
    }

    private void registerComponent(Object component, String beanName, String parentName, boolean registerSingleton) {
        if (component instanceof IntegrationEvaluationContextAware) {
            StandardEvaluationContext evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.beanFactory);
            ((IntegrationEvaluationContextAware)component).setIntegrationEvaluationContext((EvaluationContext)evaluationContext);
        }
        if (component instanceof ApplicationListener) {
            this.applicationListeners.add((ApplicationListener)component);
        }
        this.autowiredAnnotationBeanPostProcessor.processInjection(component);
        this.beanFactory.initializeBean(component, beanName);
        if (registerSingleton) {
            this.beanFactory.registerSingleton(beanName, component);
            if (parentName != null) {
                this.beanFactory.registerDependentBean(parentName, beanName);
            }
        }
    }

    private String generateBeanName(Object instance) {
        String generatedBeanName;
        if (instance instanceof NamedComponent && ((NamedComponent)instance).getComponentName() != null) {
            return ((NamedComponent)instance).getComponentName();
        }
        String id = generatedBeanName = instance.getClass().getName();
        int counter = -1;
        while (counter == -1 || this.beanFactory.containsBean(id)) {
            id = generatedBeanName + "#" + ++counter;
        }
        return id;
    }

    private static boolean isLambda(Object o) {
        Class<?> aClass = o.getClass();
        return aClass.isSynthetic() && !aClass.isAnonymousClass() && !aClass.isLocalClass();
    }
}

