/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.context;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowRegistration;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;

public final class IntegrationFlowContext
implements BeanFactoryAware {
    private final Map<String, IntegrationFlowRegistration> registry = new HashMap<String, IntegrationFlowRegistration>();
    private ConfigurableListableBeanFactory beanFactory;
    private AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor;

    private IntegrationFlowContext() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"To use Spring Integration Java DSL the 'beanFactory' has to be an instance of 'ConfigurableListableBeanFactory'. Consider using 'GenericApplicationContext' implementation.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.autowiredAnnotationBeanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        this.autowiredAnnotationBeanPostProcessor.setBeanFactory((BeanFactory)this.beanFactory);
    }

    public IntegrationFlowRegistrationBuilder registration(IntegrationFlow integrationFlow) {
        return new IntegrationFlowRegistrationBuilder(integrationFlow);
    }

    private void register(IntegrationFlowRegistrationBuilder builder) {
        IntegrationFlow integrationFlow = builder.integrationFlowRegistration.getIntegrationFlow();
        String flowId = builder.integrationFlowRegistration.getId();
        if (flowId == null) {
            flowId = this.generateBeanName(integrationFlow, null);
            builder.id(flowId);
        }
        IntegrationFlow theFlow = (IntegrationFlow)this.registerBean(integrationFlow, flowId, null);
        builder.integrationFlowRegistration.setIntegrationFlow(theFlow);
        for (Map.Entry entry : builder.additionalBeans.entrySet()) {
            this.registerBean(entry.getKey(), (String)entry.getValue(), flowId);
        }
        if (builder.autoStartup) {
            builder.integrationFlowRegistration.start();
        }
        this.registry.put(flowId, builder.integrationFlowRegistration);
    }

    private Object registerBean(Object bean, String beanName, String parentName) {
        if (beanName == null) {
            beanName = this.generateBeanName(bean, parentName);
        }
        this.autowiredAnnotationBeanPostProcessor.processInjection(bean);
        bean = this.beanFactory.initializeBean(bean, beanName);
        this.beanFactory.registerSingleton(beanName, bean);
        if (parentName != null) {
            this.beanFactory.registerDependentBean(parentName, beanName);
        }
        return bean;
    }

    public IntegrationFlowRegistration getRegistrationById(String flowId) {
        return this.registry.get(flowId);
    }

    public synchronized void remove(String flowId) {
        if (!this.registry.containsKey(flowId)) {
            throw new IllegalStateException("Only manually registered IntegrationFlows can be removed. But [" + flowId + "] ins't one of them.");
        }
        IntegrationFlowRegistration flowRegistration = this.registry.remove(flowId);
        flowRegistration.stop();
        ((DefaultSingletonBeanRegistry)this.beanFactory).destroySingleton(flowId);
    }

    public MessagingTemplate messagingTemplateFor(String flowId) {
        return this.registry.get(flowId).getMessagingTemplate();
    }

    private String generateBeanName(Object instance, String parentName) {
        String generatedBeanName;
        if (instance instanceof NamedComponent && ((NamedComponent)instance).getComponentName() != null) {
            return ((NamedComponent)instance).getComponentName();
        }
        String id = generatedBeanName = (parentName != null ? parentName : "") + instance.getClass().getName();
        int counter = -1;
        while (counter == -1 || this.beanFactory.containsBean(id)) {
            id = generatedBeanName + "#" + ++counter;
        }
        return id;
    }

    public final class IntegrationFlowRegistrationBuilder {
        private Map<Object, String> additionalBeans = new HashMap<Object, String>();
        private final IntegrationFlowRegistration integrationFlowRegistration;
        private boolean autoStartup = true;

        private IntegrationFlowRegistrationBuilder(IntegrationFlow integrationFlow) {
            this.integrationFlowRegistration = new IntegrationFlowRegistration(integrationFlow);
            this.integrationFlowRegistration.setBeanFactory(IntegrationFlowContext.this.beanFactory);
            this.integrationFlowRegistration.setIntegrationFlowContext(IntegrationFlowContext.this);
        }

        public IntegrationFlowRegistrationBuilder id(String id) {
            this.integrationFlowRegistration.setId(id);
            return this;
        }

        public IntegrationFlowRegistrationBuilder autoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
            return this;
        }

        public IntegrationFlowRegistrationBuilder addBean(Object bean) {
            return this.addBean(null, bean);
        }

        public IntegrationFlowRegistrationBuilder addBean(String name, Object bean) {
            this.additionalBeans.put(bean, name);
            return this;
        }

        public IntegrationFlowRegistration register() {
            IntegrationFlowContext.this.register(this);
            return this.integrationFlowRegistration;
        }
    }
}

