/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class FileTransferringMessageHandlerSpec<F, S extends FileTransferringMessageHandlerSpec<F, S>>
extends MessageHandlerSpec<S, FileTransferringMessageHandler<F>>
implements ComponentsRegistration {
    private FileNameGenerator fileNameGenerator;
    private DefaultFileNameGenerator defaultFileNameGenerator;

    protected FileTransferringMessageHandlerSpec(SessionFactory<F> sessionFactory) {
        this.target = new FileTransferringMessageHandler(sessionFactory);
    }

    protected FileTransferringMessageHandlerSpec(RemoteFileTemplate<F> remoteFileTemplate) {
        this.target = new FileTransferringMessageHandler(remoteFileTemplate);
    }

    protected FileTransferringMessageHandlerSpec(RemoteFileTemplate<F> remoteFileTemplate, FileExistsMode fileExistsMode) {
        this.target = new FileTransferringMessageHandler(remoteFileTemplate, fileExistsMode);
    }

    public S autoCreateDirectory(boolean autoCreateDirectory) {
        ((FileTransferringMessageHandler)this.target).setAutoCreateDirectory(autoCreateDirectory);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        ((FileTransferringMessageHandler)this.target).setRemoteFileSeparator(remoteFileSeparator);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S remoteDirectory(String remoteDirectory) {
        ((FileTransferringMessageHandler)this.target).setRemoteDirectoryExpression((Expression)new LiteralExpression(remoteDirectory));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S remoteDirectoryExpression(String remoteDirectoryExpression) {
        ((FileTransferringMessageHandler)this.target).setRemoteDirectoryExpression(PARSER.parseExpression(remoteDirectoryExpression));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public <P> S remoteDirectory(Function<Message<P>, String> remoteDirectoryFunction) {
        ((FileTransferringMessageHandler)this.target).setRemoteDirectoryExpression(new FunctionExpression<Message<P>>(remoteDirectoryFunction));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S temporaryRemoteDirectory(String temporaryRemoteDirectory) {
        ((FileTransferringMessageHandler)this.target).setTemporaryRemoteDirectoryExpression((Expression)new LiteralExpression(temporaryRemoteDirectory));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S temporaryRemoteDirectoryExpression(String temporaryRemoteDirectoryExpression) {
        ((FileTransferringMessageHandler)this.target).setTemporaryRemoteDirectoryExpression(PARSER.parseExpression(temporaryRemoteDirectoryExpression));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public <P> S temporaryRemoteDirectory(Function<Message<P>, String> temporaryRemoteDirectoryFunction) {
        ((FileTransferringMessageHandler)this.target).setTemporaryRemoteDirectoryExpression(new FunctionExpression<Message<P>>(temporaryRemoteDirectoryFunction));
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S useTemporaryFileName(boolean useTemporaryFileName) {
        ((FileTransferringMessageHandler)this.target).setUseTemporaryFileName(useTemporaryFileName);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S fileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
        ((FileTransferringMessageHandler)this.target).setFileNameGenerator(fileNameGenerator);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S fileNameExpression(String fileNameGeneratorExpression) {
        Assert.isNull((Object)this.fileNameGenerator, (String)"'fileNameGenerator' and 'fileNameGeneratorExpression' are mutually exclusive.");
        this.defaultFileNameGenerator = new DefaultFileNameGenerator();
        this.defaultFileNameGenerator.setExpression(fileNameGeneratorExpression);
        return this.fileNameGenerator((FileNameGenerator)this.defaultFileNameGenerator);
    }

    public S charset(String charset) {
        ((FileTransferringMessageHandler)this.target).setCharset(charset);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    public S charset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' must not be null.");
        return this.charset(charset.name());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        ((FileTransferringMessageHandler)this.target).setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((FileTransferringMessageHandlerSpec)this._this());
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        if (this.defaultFileNameGenerator != null) {
            return Collections.singletonList(this.defaultFileNameGenerator);
        }
        return null;
    }
}

