/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapterSpec<K, V, S extends KafkaMessageDrivenChannelAdapterSpec<K, V, S>>
extends MessageProducerSpec<S, KafkaMessageDrivenChannelAdapter<K, V>> {
    private AbstractMessageListenerContainer<K, V> messageListenerContainer;
    private boolean batchMode;

    KafkaMessageDrivenChannelAdapterSpec(AbstractMessageListenerContainer<K, V> messageListenerContainer) {
        super(null);
        this.messageListenerContainer = messageListenerContainer;
    }

    public KafkaMessageDrivenChannelAdapterSpec<K, V, S> batchMode(boolean batchMode) {
        this.batchMode = batchMode;
        return this;
    }

    @Override
    protected KafkaMessageDrivenChannelAdapter<K, V> doGet() {
        if (this.batchMode) {
            return new KafkaMessageDrivenChannelAdapter(this.messageListenerContainer, KafkaMessageDrivenChannelAdapter.ListenerMode.batch);
        }
        return new KafkaMessageDrivenChannelAdapter(this.messageListenerContainer);
    }

    public static class KafkaMessageListenerContainerSpec<K, V> {
        private final ConcurrentMessageListenerContainer<K, V> container;

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties) {
            this.container = new ConcurrentMessageListenerContainer(consumerFactory, containerProperties);
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, TopicPartitionInitialOffset ... topicPartitions) {
            this(consumerFactory, new ContainerProperties(topicPartitions));
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, String ... topics) {
            this(consumerFactory, new ContainerProperties(topics));
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, Pattern topicPattern) {
            this(consumerFactory, new ContainerProperties(topicPattern));
        }

        public KafkaMessageListenerContainerSpec<K, V> concurrency(int concurrency) {
            this.container.setConcurrency(concurrency);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> errorHandler(ErrorHandler errorHandler) {
            this.container.getContainerProperties().setErrorHandler(errorHandler);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackMode(AbstractMessageListenerContainer.AckMode ackMode) {
            this.container.getContainerProperties().setAckMode(ackMode);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pollTimeout(long pollTimeout) {
            this.container.getContainerProperties().setPollTimeout(pollTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackCount(int count) {
            this.container.getContainerProperties().setAckCount(count);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackTime(long millis) {
            this.container.getContainerProperties().setAckTime(millis);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> consumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
            this.container.getContainerProperties().setConsumerTaskExecutor(consumerTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> listenerTaskExecutor(AsyncListenableTaskExecutor listenerTaskExecutor) {
            this.container.getContainerProperties().setListenerTaskExecutor(listenerTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pauseAfter(long pauseAfter) {
            this.container.getContainerProperties().setPauseAfter(pauseAfter);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pauseEnabled(boolean pauseEnabled) {
            this.container.getContainerProperties().setPauseEnabled(pauseEnabled);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> queueDepth(int queueDepth) {
            this.container.getContainerProperties().setQueueDepth(queueDepth);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> shutdownTimeout(long shutdownTimeout) {
            this.container.getContainerProperties().setShutdownTimeout(shutdownTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> consumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
            this.container.getContainerProperties().setConsumerRebalanceListener(consumerRebalanceListener);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> commitCallback(OffsetCommitCallback commitCallback) {
            this.container.getContainerProperties().setCommitCallback(commitCallback);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> syncCommits(boolean syncCommits) {
            this.container.getContainerProperties().setSyncCommits(syncCommits);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> idleEventInterval(Long idleEventInterval) {
            this.container.getContainerProperties().setIdleEventInterval(idleEventInterval);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackOnError(boolean ackOnError) {
            this.container.getContainerProperties().setAckOnError(ackOnError);
            return this;
        }
    }

    public static class KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>
    extends KafkaMessageDrivenChannelAdapterSpec<K, V, KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>>
    implements ComponentsRegistration {
        private KafkaMessageListenerContainerSpec<K, V> spec;

        KafkaMessageDrivenChannelAdapterListenerContainerSpec(KafkaMessageListenerContainerSpec<K, V> spec) {
            super(((KafkaMessageListenerContainerSpec)spec).container);
            this.spec = spec;
        }

        public KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> configureListenerContainer(Consumer<KafkaMessageListenerContainerSpec<K, V>> configurer) {
            Assert.notNull(configurer);
            configurer.accept(this.spec);
            return (KafkaMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        @Override
        public Collection<Object> getComponentsToRegister() {
            return Collections.singleton(((KafkaMessageListenerContainerSpec)this.spec).container);
        }
    }
}

