/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.jms.JmsTemplateSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.jms.JmsDestinationPollingSource;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class JmsInboundChannelAdapterSpec<S extends JmsInboundChannelAdapterSpec<S>>
extends MessageSourceSpec<S, JmsDestinationPollingSource> {
    final JmsTemplateSpec jmsTemplateSpec = new JmsTemplateSpec();

    JmsInboundChannelAdapterSpec(JmsTemplate jmsTemplate) {
        this.target = new JmsDestinationPollingSource(jmsTemplate);
    }

    private JmsInboundChannelAdapterSpec(ConnectionFactory connectionFactory) {
        this.target = new JmsDestinationPollingSource((JmsTemplate)((JmsTemplateSpec)this.jmsTemplateSpec.connectionFactory(connectionFactory)).get());
    }

    public S messageSelector(String messageSelector) {
        ((JmsDestinationPollingSource)this.target).setMessageSelector(messageSelector);
        return (S)((JmsInboundChannelAdapterSpec)this._this());
    }

    public S headerMapper(JmsHeaderMapper headerMapper) {
        ((JmsDestinationPollingSource)this.target).setHeaderMapper(headerMapper);
        return (S)((JmsInboundChannelAdapterSpec)this._this());
    }

    public S destination(Destination destination) {
        ((JmsDestinationPollingSource)this.target).setDestination(destination);
        return (S)((JmsInboundChannelAdapterSpec)this._this());
    }

    public S destination(String destination) {
        ((JmsDestinationPollingSource)this.target).setDestinationName(destination);
        return (S)((JmsInboundChannelAdapterSpec)this._this());
    }

    public static class JmsInboundChannelSpecTemplateAware
    extends JmsInboundChannelAdapterSpec<JmsInboundChannelSpecTemplateAware> {
        JmsInboundChannelSpecTemplateAware(ConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        public JmsInboundChannelSpecTemplateAware configureJmsTemplate(Consumer<JmsTemplateSpec> configurer) {
            Assert.notNull(configurer, (String)"'configurer' must not be null");
            configurer.accept(this.jmsTemplateSpec);
            return (JmsInboundChannelSpecTemplateAware)this._this();
        }
    }
}

