/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.integration.dsl.jms.JmsDefaultListenerContainerSpec;
import org.springframework.integration.dsl.jms.JmsInboundChannelAdapterSpec;
import org.springframework.integration.dsl.jms.JmsInboundGatewaySpec;
import org.springframework.integration.dsl.jms.JmsListenerContainerSpec;
import org.springframework.integration.dsl.jms.JmsMessageChannelSpec;
import org.springframework.integration.dsl.jms.JmsMessageDrivenChannelAdapterSpec;
import org.springframework.integration.dsl.jms.JmsOutboundChannelAdapterSpec;
import org.springframework.integration.dsl.jms.JmsOutboundGatewaySpec;
import org.springframework.integration.dsl.jms.JmsPollableMessageChannelSpec;
import org.springframework.integration.dsl.jms.JmsPublishSubscribeMessageChannelSpec;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public final class Jms {
    public static <S extends JmsPollableMessageChannelSpec<S>> JmsPollableMessageChannelSpec<S> pollableChannel(ConnectionFactory connectionFactory) {
        return Jms.pollableChannel(null, connectionFactory);
    }

    public static <S extends JmsPollableMessageChannelSpec<S>> JmsPollableMessageChannelSpec<S> pollableChannel(String id, ConnectionFactory connectionFactory) {
        return new JmsPollableMessageChannelSpec(connectionFactory).id(id);
    }

    public static <S extends JmsMessageChannelSpec<S>> JmsMessageChannelSpec<S> channel(ConnectionFactory connectionFactory) {
        return Jms.channel(null, connectionFactory);
    }

    public static <S extends JmsMessageChannelSpec<S>> JmsMessageChannelSpec<S> channel(String id, ConnectionFactory connectionFactory) {
        return (JmsMessageChannelSpec)new JmsMessageChannelSpec(connectionFactory).id(id);
    }

    public static JmsPublishSubscribeMessageChannelSpec publishSubscribeChannel(ConnectionFactory connectionFactory) {
        return Jms.publishSubscribeChannel(null, connectionFactory);
    }

    public static JmsPublishSubscribeMessageChannelSpec publishSubscribeChannel(String id, ConnectionFactory connectionFactory) {
        return (JmsPublishSubscribeMessageChannelSpec)new JmsPublishSubscribeMessageChannelSpec(connectionFactory).id(id);
    }

    public static <S extends JmsOutboundChannelAdapterSpec<S>> JmsOutboundChannelAdapterSpec<S> outboundAdapter(JmsTemplate jmsTemplate) {
        return new JmsOutboundChannelAdapterSpec(jmsTemplate);
    }

    public static JmsOutboundChannelAdapterSpec.JmsOutboundChannelSpecTemplateAware outboundAdapter(ConnectionFactory connectionFactory) {
        return new JmsOutboundChannelAdapterSpec.JmsOutboundChannelSpecTemplateAware(connectionFactory);
    }

    public static <S extends JmsInboundChannelAdapterSpec<S>> JmsInboundChannelAdapterSpec<S> inboundAdapter(JmsTemplate jmsTemplate) {
        return new JmsInboundChannelAdapterSpec(jmsTemplate);
    }

    public static JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware inboundAdapter(ConnectionFactory connectionFactory) {
        return new JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware(connectionFactory);
    }

    public static JmsOutboundGatewaySpec outboundGateway(ConnectionFactory connectionFactory) {
        return new JmsOutboundGatewaySpec(connectionFactory);
    }

    public static <S extends JmsInboundGatewaySpec<S>> JmsInboundGatewaySpec<S> inboundGateway(AbstractMessageListenerContainer listenerContainer) {
        return new JmsInboundGatewaySpec(listenerContainer);
    }

    public static JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> inboundGateway(ConnectionFactory connectionFactory) {
        return Jms.inboundGateway(connectionFactory, DefaultMessageListenerContainer.class);
    }

    public static <S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer> JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<S, C> inboundGateway(ConnectionFactory connectionFactory, Class<C> containerClass) {
        try {
            JmsListenerContainerSpec spec = (JmsListenerContainerSpec)new JmsListenerContainerSpec(containerClass).connectionFactory(connectionFactory);
            return new JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public static <S extends JmsMessageDrivenChannelAdapterSpec<S>> JmsMessageDrivenChannelAdapterSpec<S> messageDriverChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        return Jms.messageDrivenChannelAdapter(listenerContainer);
    }

    @Deprecated
    public static JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> messageDriverChannelAdapter(ConnectionFactory connectionFactory) {
        return Jms.messageDrivenChannelAdapter(connectionFactory);
    }

    @Deprecated
    public static <S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer> JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C> messageDriverChannelAdapter(ConnectionFactory connectionFactory, Class<C> containerClass) {
        return Jms.messageDrivenChannelAdapter(connectionFactory, containerClass);
    }

    public static <S extends JmsMessageDrivenChannelAdapterSpec<S>> JmsMessageDrivenChannelAdapterSpec<S> messageDrivenChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        return new JmsMessageDrivenChannelAdapterSpec(listenerContainer);
    }

    public static JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> messageDrivenChannelAdapter(ConnectionFactory connectionFactory) {
        try {
            return new JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer>((JmsListenerContainerSpec)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer> JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<S, C> messageDrivenChannelAdapter(ConnectionFactory connectionFactory, Class<C> containerClass) {
        try {
            JmsListenerContainerSpec spec = (JmsListenerContainerSpec)new JmsListenerContainerSpec(containerClass).connectionFactory(connectionFactory);
            return new JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsDefaultListenerContainerSpec container(ConnectionFactory connectionFactory, Destination destination) {
        try {
            return (JmsDefaultListenerContainerSpec)((JmsDefaultListenerContainerSpec)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory)).destination(destination);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsDefaultListenerContainerSpec container(ConnectionFactory connectionFactory, String destinationName) {
        try {
            return (JmsDefaultListenerContainerSpec)((JmsDefaultListenerContainerSpec)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory)).destination(destinationName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Jms() {
    }
}

