/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcMessageHandler
extends AbstractMessageHandler
implements InitializingBean {
    private final StoredProcExecutor executor;

    @Deprecated
    public StoredProcMessageHandler(DataSource dataSource, String storedProcedureName) {
        Assert.notNull((Object)dataSource, (String)"dataSource must not be null.");
        Assert.hasText((String)storedProcedureName, (String)"storedProcedureName must not be null and cannot be empty.");
        this.executor = new StoredProcExecutor(dataSource);
        this.executor.setStoredProcedureName(storedProcedureName);
    }

    public StoredProcMessageHandler(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    protected void onInit() throws Exception {
        super.onInit();
    }

    protected void handleMessageInternal(Message<?> message) {
        Map<String, Object> resultMap = this.executor.executeStoredProcedure(message);
        if (this.logger.isDebugEnabled() && resultMap != null && !resultMap.isEmpty()) {
            this.logger.debug((Object)String.format("The StoredProcMessageHandler ignores return values, but the called Stored Procedure returned data: '%s'", this.executor.getStoredProcedureName(), resultMap));
        }
    }

    @Deprecated
    public void setStoredProcedureName(String storedProcedureName) {
        this.executor.setStoredProcedureName(storedProcedureName);
    }

    @Deprecated
    public void setIgnoreColumnMetaData(boolean ignoreColumnMetaData) {
        this.executor.setIgnoreColumnMetaData(ignoreColumnMetaData);
    }

    @Deprecated
    public void setProcedureParameters(List<ProcedureParameter> procedureParameters) {
        this.executor.setProcedureParameters(procedureParameters);
    }

    @Deprecated
    public void setSqlParameters(List<SqlParameter> sqlParameters) {
        this.executor.setSqlParameters(sqlParameters);
    }

    @Deprecated
    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.executor.setSqlParameterSourceFactory(sqlParameterSourceFactory);
    }

    @Deprecated
    public void setUsePayloadAsParameterSource(boolean usePayloadAsParameterSource) {
        this.executor.setUsePayloadAsParameterSource(usePayloadAsParameterSource);
    }
}

