/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class BeanPropertySqlParameterSourceFactory
implements SqlParameterSourceFactory {
    private volatile Map<String, Object> staticParameters = Collections.unmodifiableMap(new HashMap());

    public void setStaticParameters(Map<String, Object> staticParameters) {
        this.staticParameters = staticParameters;
    }

    @Override
    public SqlParameterSource createParameterSource(Object input) {
        StaticBeanPropertySqlParameterSource toReturn = new StaticBeanPropertySqlParameterSource(input, this.staticParameters);
        return toReturn;
    }

    private static class StaticBeanPropertySqlParameterSource
    extends AbstractSqlParameterSource
    implements SqlParameterSource {
        private final BeanPropertySqlParameterSource input;
        private final Map<String, Object> staticParameters;

        public StaticBeanPropertySqlParameterSource(Object input, Map<String, Object> staticParameters) {
            this.input = new BeanPropertySqlParameterSource(input);
            this.staticParameters = staticParameters;
        }

        public Object getValue(String paramName) throws IllegalArgumentException {
            return this.staticParameters.containsKey(paramName) ? this.staticParameters.get(paramName) : this.input.getValue(paramName);
        }

        public boolean hasValue(String paramName) {
            return this.staticParameters.containsKey(paramName) || this.input.hasValue(paramName);
        }
    }
}

