/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store.channel;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.integration.Message;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.LobHandler;

public class MessageRowMapper
implements RowMapper<Message<?>> {
    private final DeserializingConverter deserializer;
    private final LobHandler lobHandler;

    public MessageRowMapper(DeserializingConverter deserializer, LobHandler lobHandler) {
        this.deserializer = deserializer;
        this.lobHandler = lobHandler;
    }

    public Message<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
        return (Message)this.deserializer.convert(this.lobHandler.getBlobAsBytes(rs, "MESSAGE_BYTES"));
    }
}

