/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.lock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.integration.jdbc.lock.LockRepository;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.util.Assert;

public class JdbcLockRegistry
implements ExpirableLockRegistry {
    private final Map<String, JdbcLock> locks = new HashMap<String, JdbcLock>();
    private LockRepository client;

    public JdbcLockRegistry(LockRepository client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = this.pathFor((String)lockKey);
        JdbcLock lock = this.locks.get(path);
        if (lock == null) {
            Map<String, JdbcLock> map = this.locks;
            synchronized (map) {
                lock = this.locks.get(path);
                if (lock == null) {
                    lock = new JdbcLock(this.client, path);
                    this.locks.put(path, lock);
                }
            }
        }
        return lock;
    }

    private String pathFor(String input) {
        return input == null ? null : UUIDConverter.getUUID((Object)input).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedOlderThan(long age) {
        Map<String, JdbcLock> map = this.locks;
        synchronized (map) {
            Iterator<Map.Entry<String, JdbcLock>> iterator = this.locks.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry<String, JdbcLock> entry = iterator.next();
                JdbcLock lock = entry.getValue();
                if (now - lock.getLastUsed() <= age || lock.isAcquiredInThisProcess()) continue;
                iterator.remove();
            }
        }
    }

    private static final class JdbcLock
    implements Lock {
        private final LockRepository mutex;
        private final String path;
        private volatile long lastUsed = System.currentTimeMillis();
        private ReentrantLock delegate = new ReentrantLock();

        private JdbcLock(LockRepository client, String path) {
            this.mutex = client;
            this.path = path;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        @Override
        public void lock() {
            this.delegate.lock();
            while (true) {
                try {
                    while (!this.doLock()) {
                        Thread.sleep(100L);
                    }
                }
                catch (TransientDataAccessException transientDataAccessException) {
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        private void rethrowAsLockException(Exception e) {
            throw new CannotAcquireLockException("Failed to lock mutex at " + this.path, (Throwable)e);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
            while (true) {
                try {
                    while (!this.doLock()) {
                        Thread.sleep(100L);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (TransientDataAccessException transientDataAccessException) {
                    continue;
                }
                catch (InterruptedException ie) {
                    this.delegate.unlock();
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            long now = System.currentTimeMillis();
            if (!this.delegate.tryLock(time, unit)) {
                return false;
            }
            long expire = now + TimeUnit.MILLISECONDS.convert(time, unit);
            while (true) {
                try {
                    boolean acquired;
                    while (!(acquired = this.doLock()) && System.currentTimeMillis() < expire) {
                        Thread.sleep(100L);
                    }
                    if (!acquired) {
                        this.delegate.unlock();
                    }
                    return acquired;
                }
                catch (TransientDataAccessException transientDataAccessException) {
                    continue;
                }
                catch (Exception e) {
                    this.delegate.unlock();
                    this.rethrowAsLockException(e);
                    continue;
                }
                break;
            }
        }

        private boolean doLock() {
            boolean acquired = this.mutex.acquire(this.path);
            if (acquired) {
                this.lastUsed = System.currentTimeMillis();
            }
            return acquired;
        }

        @Override
        public void unlock() {
            if (!this.delegate.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException("You do not own mutex at " + this.path);
            }
            if (this.delegate.getHoldCount() > 1) {
                this.delegate.unlock();
                return;
            }
            try {
                this.mutex.delete(this.path);
            }
            catch (Exception e) {
                throw new DataAccessResourceFailureException("Failed to release mutex at " + this.path, (Throwable)e);
            }
            finally {
                this.delegate.unlock();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public boolean isAcquiredInThisProcess() {
            return this.mutex.isAcquired(this.path);
        }
    }
}

