/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public abstract class AbstractJmsTemplateBasedAdapter
implements InitializingBean {
    private volatile ConnectionFactory connectionFactory;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile DestinationResolver destinationResolver;
    private volatile JmsTemplate jmsTemplate;
    private volatile JmsHeaderMapper headerMapper;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();

    public AbstractJmsTemplateBasedAdapter(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public AbstractJmsTemplateBasedAdapter(ConnectionFactory connectionFactory, Destination destination) {
        this.connectionFactory = connectionFactory;
        this.destination = destination;
    }

    public AbstractJmsTemplateBasedAdapter(ConnectionFactory connectionFactory, String destinationName) {
        this.connectionFactory = connectionFactory;
        this.destinationName = destinationName;
    }

    public AbstractJmsTemplateBasedAdapter() {
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    protected JmsTemplate getJmsTemplate() {
        if (this.jmsTemplate == null) {
            this.afterPropertiesSet();
        }
        return this.jmsTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            if (this.jmsTemplate == null) {
                Assert.isTrue((this.connectionFactory != null && (this.destination != null || this.destinationName != null) ? 1 : 0) != 0, (String)"Either a 'jmsTemplate' or *both* 'connectionFactory' and 'destination' (or 'destination-name') are required.");
                this.jmsTemplate = this.createDefaultJmsTemplate();
            }
            this.configureMessageConverter(this.jmsTemplate, this.headerMapper);
            this.initialized = true;
        }
    }

    private JmsTemplate createDefaultJmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate();
        jmsTemplate.setConnectionFactory(this.connectionFactory);
        if (this.destination != null) {
            jmsTemplate.setDefaultDestination(this.destination);
        } else {
            jmsTemplate.setDefaultDestinationName(this.destinationName);
        }
        if (this.destinationResolver != null) {
            jmsTemplate.setDestinationResolver(this.destinationResolver);
        }
        return jmsTemplate;
    }

    protected abstract void configureMessageConverter(JmsTemplate var1, JmsHeaderMapper var2);
}

