/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.MessageChannelTemplate;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.jms.HeaderMappingMessageConverter;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.util.Assert;

public class ChannelPublishingJmsMessageListener
implements SessionAwareMessageListener,
InitializingBean {
    private volatile boolean expectReply;
    private volatile MessageConverter messageConverter;
    private volatile boolean extractRequestPayload = true;
    private volatile boolean extractReplyPayload = true;
    private volatile Object defaultReplyDestination;
    private volatile DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private volatile JmsHeaderMapper headerMapper;
    private final MessageChannelTemplate channelTemplate = new MessageChannelTemplate();

    public void setRequestChannel(MessageChannel requestChannel) {
        this.channelTemplate.setDefaultChannel(requestChannel);
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.channelTemplate.setSendTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.channelTemplate.setReceiveTimeout(replyTimeout);
    }

    public void setDefaultReplyDestination(Destination defaultReplyDestination) {
        this.defaultReplyDestination = defaultReplyDestination;
    }

    public void setDefaultReplyQueueName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, false);
    }

    public void setDefaultReplyTopicName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, true);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull((Object)destinationResolver, (String)"destinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public final void afterPropertiesSet() {
        if (!(this.messageConverter instanceof HeaderMappingMessageConverter)) {
            HeaderMappingMessageConverter hmmc = new HeaderMappingMessageConverter(this.messageConverter, this.headerMapper);
            hmmc.setExtractJmsMessageBody(this.extractRequestPayload);
            hmmc.setExtractIntegrationMessagePayload(this.extractReplyPayload);
            this.messageConverter = hmmc;
        }
    }

    public void onMessage(javax.jms.Message jmsMessage, Session session) throws JMSException {
        Message requestMessage;
        Object object = this.messageConverter.fromMessage(jmsMessage);
        Message message = requestMessage = object instanceof Message ? (Message)object : MessageBuilder.withPayload((Object)object).build();
        if (!this.expectReply) {
            boolean sent = this.channelTemplate.send(requestMessage);
            if (!sent) {
                throw new MessageDeliveryException(requestMessage, "failed to send Message to request channel");
            }
        } else {
            Message replyMessage = this.channelTemplate.sendAndReceive(requestMessage);
            if (replyMessage != null) {
                Destination destination = this.getReplyDestination(jmsMessage, session);
                javax.jms.Message jmsReply = this.messageConverter.toMessage((Object)replyMessage, session);
                if (jmsReply.getJMSCorrelationID() == null) {
                    jmsReply.setJMSCorrelationID(jmsMessage.getJMSMessageID());
                }
                MessageProducer producer = session.createProducer(destination);
                try {
                    producer.send(jmsReply);
                }
                finally {
                    producer.close();
                }
            }
        }
    }

    private Destination getReplyDestination(javax.jms.Message request, Session session) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && (replyTo = this.resolveDefaultReplyDestination(session)) == null) {
            throw new InvalidDestinationException("Cannot determine reply destination: Request message does not contain reply-to destination, and no default reply destination set.");
        }
        return replyTo;
    }

    private Destination resolveDefaultReplyDestination(Session session) throws JMSException {
        if (this.defaultReplyDestination instanceof Destination) {
            return (Destination)this.defaultReplyDestination;
        }
        if (this.defaultReplyDestination instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)this.defaultReplyDestination;
            return this.destinationResolver.resolveDestinationName(session, nameHolder.name, nameHolder.isTopic);
        }
        return null;
    }

    private static class DestinationNameHolder {
        public final String name;
        public final boolean isTopic;

        public DestinationNameHolder(String name, boolean isTopic) {
            this.name = name;
            this.isTopic = isTopic;
        }
    }
}

