/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.adapter.MessageMappingException;
import org.springframework.integration.core.MessageHeaders;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJmsHeaderMapper
implements JmsHeaderMapper {
    private static List<Class<?>> SUPPORTED_PROPERTY_TYPES = Arrays.asList(Boolean.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class);
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void fromHeaders(MessageHeaders headers, Message jmsMessage) {
        block8: {
            try {
                Object jmsType;
                Object jmsReplyTo;
                Object jmsCorrelationId = headers.get((Object)"springintegration_jms_correlationId");
                if (jmsCorrelationId != null && jmsCorrelationId instanceof String) {
                    jmsMessage.setJMSCorrelationID((String)jmsCorrelationId);
                }
                if ((jmsReplyTo = headers.get((Object)"springintegration_jms_replyTo")) != null && jmsReplyTo instanceof Destination) {
                    jmsMessage.setJMSReplyTo((Destination)jmsReplyTo);
                }
                if ((jmsType = headers.get((Object)"springintegration_jms_type")) != null && jmsType instanceof String) {
                    jmsMessage.setJMSType((String)jmsType);
                }
                Set attributeNames = headers.keySet();
                for (String attributeName : attributeNames) {
                    Object value;
                    if (attributeName.startsWith("springintegration_jms_") || !StringUtils.hasText((String)attributeName) || (value = headers.get((Object)attributeName)) == null || !SUPPORTED_PROPERTY_TYPES.contains(value.getClass())) continue;
                    try {
                        jmsMessage.setObjectProperty(attributeName, value);
                    }
                    catch (Exception e) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("failed to map Message header '" + attributeName + "' to JMS property"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block8;
                this.logger.warn((Object)"error occurred while mapping properties from MessageHeaders", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> toHeaders(Message jmsMessage) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            Enumeration jmsPropertyNames;
            Destination replyTo;
            String correlationId;
            String messageId = jmsMessage.getJMSMessageID();
            if (messageId != null) {
                headers.put("springintegration_jms_messageId", messageId);
            }
            if ((correlationId = jmsMessage.getJMSCorrelationID()) != null) {
                headers.put("springintegration_jms_correlationId", correlationId);
            }
            if ((replyTo = jmsMessage.getJMSReplyTo()) != null) {
                headers.put("springintegration_jms_replyTo", replyTo);
            }
            headers.put("springintegration_jms_redelivered", jmsMessage.getJMSRedelivered());
            String type = jmsMessage.getJMSType();
            if (type != null) {
                headers.put("springintegration_jms_type", type);
            }
            if ((jmsPropertyNames = jmsMessage.getPropertyNames()) != null) {
                while (jmsPropertyNames.hasMoreElements()) {
                    String propertyName = jmsPropertyNames.nextElement().toString();
                    try {
                        headers.put(propertyName, jmsMessage.getObjectProperty(propertyName));
                    }
                    catch (Exception e) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("error occurred while mapping JMS property '" + propertyName + "' to Message header"), (Throwable)e);
                    }
                }
            }
        }
        catch (JMSException e) {
            throw new MessageMappingException("failure occurred while mapping JMS properties to MessageHeaders", (Throwable)e);
        }
        return headers;
    }
}

