/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageHeaders;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;

public class HeaderMappingMessageConverter
implements MessageConverter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MessageConverter converter;
    private final JmsHeaderMapper headerMapper;
    private volatile boolean extractJmsMessageBody = true;
    private volatile boolean extractIntegrationMessagePayload = true;

    public HeaderMappingMessageConverter() {
        this(null, null);
    }

    public HeaderMappingMessageConverter(MessageConverter converter) {
        this(converter, null);
    }

    public HeaderMappingMessageConverter(JmsHeaderMapper headerMapper) {
        this(null, headerMapper);
    }

    public HeaderMappingMessageConverter(MessageConverter converter, JmsHeaderMapper headerMapper) {
        this.converter = converter != null ? converter : new SimpleMessageConverter();
        this.headerMapper = headerMapper != null ? headerMapper : new DefaultJmsHeaderMapper();
    }

    public void setExtractJmsMessageBody(boolean extractJmsMessageBody) {
        this.extractJmsMessageBody = extractJmsMessageBody;
    }

    public void setExtractIntegrationMessagePayload(boolean extractIntegrationMessagePayload) {
        this.extractIntegrationMessagePayload = extractIntegrationMessagePayload;
    }

    public Object fromMessage(javax.jms.Message jmsMessage) throws JMSException, MessageConversionException {
        MessageBuilder builder = null;
        if (this.extractJmsMessageBody) {
            Object conversionResult = this.converter.fromMessage(jmsMessage);
            if (conversionResult == null) {
                return null;
            }
            builder = conversionResult instanceof Message ? MessageBuilder.fromMessage((Message)((Message)conversionResult)) : MessageBuilder.withPayload((Object)conversionResult);
        } else {
            builder = MessageBuilder.withPayload((Object)jmsMessage);
        }
        Map<String, Object> headers = this.headerMapper.toHeaders(jmsMessage);
        Message message = builder.copyHeadersIfAbsent(headers).build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("converted JMS Message [" + jmsMessage + "] to integration Message [" + message + "]"));
        }
        return message;
    }

    public javax.jms.Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        MessageHeaders headers = null;
        javax.jms.Message jmsMessage = null;
        if (object instanceof Message) {
            headers = ((Message)object).getHeaders();
            if (this.extractIntegrationMessagePayload) {
                object = ((Message)object).getPayload();
            }
        }
        jmsMessage = this.converter.toMessage(object, session);
        if (headers != null) {
            this.headerMapper.fromHeaders(headers, jmsMessage);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("converted [" + object + "] to JMS Message [" + jmsMessage + "]"));
        }
        return jmsMessage;
    }
}

