/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.util.Assert;

public class JmsMessageDrivenEndpoint
extends AbstractEndpoint
implements DisposableBean {
    private final AbstractMessageListenerContainer listenerContainer;
    private final ChannelPublishingJmsMessageListener listener;

    public JmsMessageDrivenEndpoint(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        Assert.notNull((Object)listenerContainer, (String)"listener container must not be null");
        Assert.notNull((Object)listener, (String)"listener must not be null");
        listenerContainer.setMessageListener((Object)listener);
        this.listener = listener;
        this.listenerContainer = listenerContainer;
    }

    protected void onInit() throws Exception {
        this.listener.afterPropertiesSet();
        if (!this.listenerContainer.isActive()) {
            this.listenerContainer.afterPropertiesSet();
        }
    }

    protected void doStart() {
        if (!this.listenerContainer.isRunning()) {
            this.listenerContainer.start();
        }
    }

    protected void doStop() {
        this.listenerContainer.stop();
    }

    public void destroy() throws Exception {
        if (this.isRunning()) {
            this.stop();
        }
        this.listenerContainer.destroy();
    }
}

