/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.core.Ordered;
import org.springframework.integration.core.Message;
import org.springframework.integration.jms.AbstractJmsTemplateBasedAdapter;
import org.springframework.integration.jms.HeaderMappingMessageConverter;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.message.MessageHandler;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSendingMessageHandler
extends AbstractJmsTemplateBasedAdapter
implements MessageHandler,
Ordered {
    private volatile boolean extractPayload = true;
    private volatile int order = Integer.MAX_VALUE;

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public final void handleMessage(Message<?> message) {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        this.getJmsTemplate().convertAndSend(message);
    }

    @Override
    protected void configureMessageConverter(JmsTemplate jmsTemplate, JmsHeaderMapper headerMapper) {
        MessageConverter converter = jmsTemplate.getMessageConverter();
        if (converter == null || !(converter instanceof HeaderMappingMessageConverter)) {
            HeaderMappingMessageConverter hmmc = new HeaderMappingMessageConverter(converter, headerMapper);
            hmmc.setExtractIntegrationMessagePayload(this.extractPayload);
            jmsTemplate.setMessageConverter((MessageConverter)hmmc);
        }
    }
}

