/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class JmsAdapterParserUtils {
    static final String JMS_TEMPLATE_ATTRIBUTE = "jms-template";
    static final String JMS_TEMPLATE_PROPERTY = "jmsTemplate";
    static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    static final String CONNECTION_FACTORY_PROPERTY = "connectionFactory";
    static final String DESTINATION_ATTRIBUTE = "destination";
    static final String DESTINATION_PROPERTY = "destination";
    static final String DESTINATION_NAME_ATTRIBUTE = "destination-name";
    static final String DESTINATION_NAME_PROPERTY = "destinationName";
    static final String HEADER_MAPPER_ATTRIBUTE = "header-mapper";
    static final String HEADER_MAPPER_PROPERTY = "headerMapper";
    static final int SESSION_TRANSACTED = 0;
    private static final int AUTO_ACKNOWLEDGE = 1;
    private static final int CLIENT_ACKNOWLEDGE = 2;
    private static final int DUPS_OK_ACKNOWLEDGE = 3;

    JmsAdapterParserUtils() {
    }

    static String determineConnectionFactoryBeanName(Element element, ParserContext parserContext) {
        String connectionFactoryBeanName = CONNECTION_FACTORY_PROPERTY;
        if (element.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText((String)(connectionFactoryBeanName = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("JMS adapter 'connection-factory' attribute must not be empty", (Object)element);
        }
        return connectionFactoryBeanName;
    }

    static Integer parseAcknowledgeMode(Element element, ParserContext parserContext) {
        String acknowledge = element.getAttribute("acknowledge");
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if ("transacted".equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if ("dups-ok".equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if ("client".equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!"auto".equals(acknowledge)) {
                parserContext.getReaderContext().error("Invalid JMS 'acknowledge' setting: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.", (Object)element);
            }
            return acknowledgeMode;
        }
        return null;
    }
}

