/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jms.config.JmsAdapterParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsMessageDrivenEndpointParser
extends AbstractSingleBeanDefinitionParser {
    private static final String DEFAULT_REPLY_DESTINATION_ATTRIB = "default-reply-destination";
    private static final String DEFAULT_REPLY_QUEUE_NAME_ATTRIB = "default-reply-queue-name";
    private static final String DEFAULT_REPLY_TOPIC_NAME_ATTRIB = "default-reply-topic-name";
    private static String[] containerAttributes = new String[]{"connectionFactory", "destination", "destination-name", "destination-resolver", "transaction-manager", "pub-sub-domain", "concurrent-consumers", "max-concurrent-consumers", "max-messages-per-task", "idle-task-execution-limit"};
    private final boolean expectReply;

    public JmsMessageDrivenEndpointParser(boolean expectReply) {
        this.expectReply = expectReply;
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.jms.JmsMessageDrivenEndpoint";
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String containerBeanName = this.parseMessageListenerContainer(element, parserContext);
        String listenerBeanName = this.parseMessageListener(element, parserContext);
        builder.addConstructorArgReference(containerBeanName);
        builder.addConstructorArgReference(listenerBeanName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
    }

    private String parseMessageListenerContainer(Element element, ParserContext parserContext) {
        if (element.hasAttribute("container")) {
            String[] stringArray = containerAttributes;
            int n = containerAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                String containerAttribute = stringArray[n2];
                if (element.hasAttribute(containerAttribute)) {
                    parserContext.getReaderContext().error("The '" + containerAttribute + "' attribute should not be provided when specifying a 'container' reference.", (Object)element);
                }
                ++n2;
            }
            return element.getAttribute("container");
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.jms.listener.DefaultMessageListenerContainer");
        String destinationAttribute = this.expectReply ? "request-destination" : "destination";
        String destinationNameAttribute = this.expectReply ? "request-destination-name" : "destination-name";
        String destination = element.getAttribute(destinationAttribute);
        String destinationName = element.getAttribute(destinationNameAttribute);
        if (!(StringUtils.hasText((String)destination) ^ StringUtils.hasText((String)destinationName))) {
            parserContext.getReaderContext().error("Exactly one of '" + destinationAttribute + "' or '" + destinationNameAttribute + "' is required.", (Object)element);
        }
        builder.addPropertyReference("connectionFactory", JmsAdapterParserUtils.determineConnectionFactoryBeanName(element, parserContext));
        if (StringUtils.hasText((String)destination)) {
            builder.addPropertyReference("destination", destination);
        } else {
            builder.addPropertyValue("destinationName", (Object)destinationName);
        }
        Integer acknowledgeMode = JmsAdapterParserUtils.parseAcknowledgeMode(element, parserContext);
        if (acknowledgeMode != null) {
            if (acknowledgeMode == 0) {
                builder.addPropertyValue("sessionTransacted", (Object)Boolean.TRUE);
            } else {
                builder.addPropertyValue("sessionAcknowledgeMode", (Object)acknowledgeMode);
            }
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"transaction-manager");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"pub-sub-domain");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"concurrent-consumers");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-concurrent-consumers");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-messages-per-task");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"idle-task-execution-limit");
        builder.addPropertyValue("autoStartup", (Object)false);
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private String parseMessageListener(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.jms.ChannelPublishingJmsMessageListener");
        builder.addPropertyValue("expectReply", (Object)this.expectReply);
        if (this.expectReply) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-channel");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-request-payload");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
            int defaults = 0;
            if (StringUtils.hasText((String)element.getAttribute(DEFAULT_REPLY_DESTINATION_ATTRIB))) {
                ++defaults;
            }
            if (StringUtils.hasText((String)element.getAttribute(DEFAULT_REPLY_QUEUE_NAME_ATTRIB))) {
                ++defaults;
            }
            if (StringUtils.hasText((String)element.getAttribute(DEFAULT_REPLY_TOPIC_NAME_ATTRIB))) {
                ++defaults;
            }
            if (defaults > 1) {
                parserContext.getReaderContext().error("At most one of 'default-reply-destination', 'default-reply-queue-name', or 'default-reply-topic-name' may be provided.", (Object)element);
            }
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)DEFAULT_REPLY_DESTINATION_ATTRIB);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)DEFAULT_REPLY_QUEUE_NAME_ATTRIB);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)DEFAULT_REPLY_TOPIC_NAME_ATTRIB);
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        } else {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"channel", (String)"requestChannel");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout", (String)"requestTimeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload", (String)"extractRequestPayload");
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"header-mapper");
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

