/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.integration.Message;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public abstract class AbstractJmsChannel
extends AbstractMessageChannel {
    private final JmsTemplate jmsTemplate;

    public AbstractJmsChannel(JmsTemplate jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"jmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
    }

    JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSend(Message<?> message, long timeout) {
        try {
            DynamicJmsTemplateProperties.setPriority(message.getHeaders().getPriority());
            this.jmsTemplate.convertAndSend(message);
        }
        finally {
            DynamicJmsTemplateProperties.clearPriority();
        }
        return true;
    }
}

