/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import javax.jms.Destination;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.DynamicJmsTemplate;
import org.springframework.integration.jms.DynamicJmsTemplateProperties;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;

public class JmsSendingMessageHandler
extends AbstractMessageHandler {
    private final JmsTemplate jmsTemplate;
    private Destination destination;
    private String destinationName;
    private JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private boolean extractPayload = true;
    private ExpressionEvaluatingMessageProcessor<?> destinationExpressionProcessor;
    private Expression deliveryModeExpression;
    private Expression timeToLiveExpression;
    private EvaluationContext evaluationContext;

    public JmsSendingMessageHandler(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestination(Destination destination) {
        Assert.isTrue((this.destinationName == null && this.destinationExpressionProcessor == null ? 1 : 0) != 0, (String)"The 'destination', 'destinationName', and 'destinationExpression' properties are mutually exclusive.");
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        Assert.isTrue((this.destination == null && this.destinationExpressionProcessor == null ? 1 : 0) != 0, (String)"The 'destination', 'destinationName', and 'destinationExpression' properties are mutually exclusive.");
        this.destinationName = destinationName;
    }

    public void setDestinationExpression(Expression destinationExpression) {
        Assert.isTrue((this.destination == null && this.destinationName == null ? 1 : 0) != 0, (String)"The 'destination', 'destinationName', and 'destinationExpression' properties are mutually exclusive.");
        this.destinationExpressionProcessor = new ExpressionEvaluatingMessageProcessor(destinationExpression);
        this.setPrimaryExpression(destinationExpression);
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"'headerMapper' cannot be null");
        this.headerMapper = headerMapper;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setDeliveryModeExpressionString(String deliveryModeExpression) {
        this.setDeliveryModeExpression(EXPRESSION_PARSER.parseExpression(deliveryModeExpression));
    }

    public void setDeliveryModeExpression(Expression deliveryModeExpression) {
        this.deliveryModeExpression = deliveryModeExpression;
    }

    public void setTimeToLiveExpressionString(String timeToLiveExpression) {
        this.setTimeToLiveExpression(EXPRESSION_PARSER.parseExpression(timeToLiveExpression));
    }

    public void setTimeToLiveExpression(Expression timeToLiveExpression) {
        this.timeToLiveExpression = timeToLiveExpression;
    }

    public String getComponentType() {
        return "jms:outbound-channel-adapter";
    }

    protected void onInit() {
        if (this.destinationExpressionProcessor != null) {
            this.destinationExpressionProcessor.setBeanFactory(this.getBeanFactory());
            ConversionService conversionService = this.getConversionService();
            if (conversionService != null) {
                this.destinationExpressionProcessor.setConversionService(conversionService);
            }
        }
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessageInternal(Message<?> message) {
        Object objectToSend = this.extractPayload ? message.getPayload() : message;
        HeaderMappingMessagePostProcessor messagePostProcessor = new HeaderMappingMessagePostProcessor(message, this.headerMapper);
        if (this.jmsTemplate instanceof DynamicJmsTemplate && this.jmsTemplate.isExplicitQosEnabled()) {
            Long timeToLive;
            Integer deliveryMode;
            Integer priority = StaticMessageHeaderAccessor.getPriority(message);
            if (priority != null) {
                DynamicJmsTemplateProperties.setPriority(priority);
            }
            if (this.deliveryModeExpression != null && (deliveryMode = (Integer)this.deliveryModeExpression.getValue(this.evaluationContext, message, Integer.class)) != null) {
                DynamicJmsTemplateProperties.setDeliveryMode(deliveryMode);
            }
            if (this.timeToLiveExpression != null && (timeToLive = (Long)this.timeToLiveExpression.getValue(this.evaluationContext, message, Long.class)) != null) {
                DynamicJmsTemplateProperties.setTimeToLive(timeToLive);
            }
        }
        try {
            this.send(this.determineDestination(message), objectToSend, messagePostProcessor);
        }
        finally {
            DynamicJmsTemplateProperties.clearPriority();
            DynamicJmsTemplateProperties.clearDeliveryMode();
            DynamicJmsTemplateProperties.clearTimeToLive();
        }
    }

    private Object determineDestination(Message<?> message) {
        if (this.destination != null) {
            return this.destination;
        }
        if (this.destinationName != null) {
            return this.destinationName;
        }
        if (this.destinationExpressionProcessor != null) {
            Object result = this.destinationExpressionProcessor.processMessage(message);
            if (!(result instanceof Destination) && !(result instanceof String)) {
                throw new MessageDeliveryException(message, "Evaluation of destinationExpression failed to produce a Destination or destination name. Result was: " + result);
            }
            return result;
        }
        return null;
    }

    private void send(Object destination, Object objectToSend, MessagePostProcessor messagePostProcessor) {
        if (destination instanceof Destination) {
            this.jmsTemplate.convertAndSend((Destination)destination, objectToSend, messagePostProcessor);
        } else if (destination instanceof String) {
            this.jmsTemplate.convertAndSend((String)destination, objectToSend, messagePostProcessor);
        } else {
            this.jmsTemplate.convertAndSend(objectToSend, messagePostProcessor);
        }
    }

    private static final class HeaderMappingMessagePostProcessor
    implements MessagePostProcessor {
        private final Message<?> integrationMessage;
        private final JmsHeaderMapper headerMapper;

        HeaderMappingMessagePostProcessor(Message<?> integrationMessage, JmsHeaderMapper headerMapper) {
            this.integrationMessage = integrationMessage;
            this.headerMapper = headerMapper;
        }

        public javax.jms.Message postProcessMessage(javax.jms.Message jmsMessage) {
            this.headerMapper.fromHeaders(this.integrationMessage.getHeaders(), jmsMessage);
            return jmsMessage;
        }
    }
}

