/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.DefaultJmsHeaderMapper;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;

public class ChannelPublishingJmsMessageListener
implements SessionAwareMessageListener<javax.jms.Message>,
InitializingBean,
TrackableComponent,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile boolean expectReply;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile boolean extractRequestPayload = true;
    private volatile boolean extractReplyPayload = true;
    private volatile Object defaultReplyDestination;
    private volatile String correlationKey;
    private volatile long replyTimeToLive = 0L;
    private volatile int replyPriority = 4;
    private volatile int replyDeliveryMode = 2;
    private volatile boolean explicitQosEnabledForReplies;
    private volatile DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private volatile JmsHeaderMapper headerMapper = new DefaultJmsHeaderMapper();
    private final GatewayDelegate gatewayDelegate = new GatewayDelegate();
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setComponentName(String componentName) {
        this.gatewayDelegate.setComponentName(componentName);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.gatewayDelegate.setRequestChannel(requestChannel);
    }

    public void setRequestChannelName(String requestChannelName) {
        this.gatewayDelegate.setRequestChannelName(requestChannelName);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.gatewayDelegate.setReplyChannel(replyChannel);
    }

    public void setReplyChannelName(String replyChannelName) {
        this.gatewayDelegate.setReplyChannelName(replyChannelName);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.gatewayDelegate.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannelName) {
        this.gatewayDelegate.setErrorChannelName(errorChannelName);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.gatewayDelegate.setRequestTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.gatewayDelegate.setReplyTimeout(replyTimeout);
    }

    public void setErrorOnTimeout(boolean errorOnTimeout) {
        this.gatewayDelegate.setErrorOnTimeout(errorOnTimeout);
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.gatewayDelegate.setShouldTrack(shouldTrack);
    }

    public String getComponentName() {
        return this.gatewayDelegate.getComponentName();
    }

    public String getComponentType() {
        return this.gatewayDelegate.getComponentType();
    }

    public void setDefaultReplyDestination(Destination defaultReplyDestination) {
        this.defaultReplyDestination = defaultReplyDestination;
    }

    public void setDefaultReplyQueueName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, false);
    }

    public void setDefaultReplyTopicName(String destinationName) {
        this.defaultReplyDestination = new DestinationNameHolder(destinationName, true);
    }

    public void setReplyTimeToLive(long replyTimeToLive) {
        this.replyTimeToLive = replyTimeToLive;
    }

    public void setReplyPriority(int replyPriority) {
        this.replyPriority = replyPriority;
    }

    public void setReplyDeliveryPersistent(boolean replyDeliveryPersistent) {
        this.replyDeliveryMode = replyDeliveryPersistent ? 2 : 1;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public void setExplicitQosEnabledForReplies(boolean explicitQosEnabledForReplies) {
        this.explicitQosEnabledForReplies = explicitQosEnabledForReplies;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull((Object)destinationResolver, (String)"destinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExtractRequestPayload(boolean extractRequestPayload) {
        this.extractRequestPayload = extractRequestPayload;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void onMessage(javax.jms.Message jmsMessage, Session session) throws JMSException {
        Object result = jmsMessage;
        Message requestMessage = null;
        boolean errors = false;
        try {
            if (this.extractRequestPayload) {
                result = this.messageConverter.fromMessage(jmsMessage);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("converted JMS Message [" + jmsMessage + "] to integration Message payload [" + result + "]"));
                }
            }
            Map headers = this.headerMapper.toHeaders(jmsMessage);
            requestMessage = result instanceof Message ? this.messageBuilderFactory.fromMessage((Message)result).copyHeaders(headers).build() : this.messageBuilderFactory.withPayload(result).copyHeaders(headers).build();
        }
        catch (RuntimeException e) {
            MessageChannel errorChannel = this.gatewayDelegate.getErrorChannel();
            if (errorChannel == null) {
                throw e;
            }
            this.gatewayDelegate.getMessagingTemplate().send((Object)errorChannel, (Message)this.gatewayDelegate.buildErrorMessage((Throwable)new MessagingException("Inbound conversion failed for: " + jmsMessage, (Throwable)e)));
            errors = true;
        }
        if (!errors) {
            if (!this.expectReply) {
                this.gatewayDelegate.send(requestMessage);
            } else {
                Message<?> replyMessage = this.gatewayDelegate.sendAndReceiveMessage(requestMessage);
                if (replyMessage != null) {
                    Destination destination = this.getReplyDestination(jmsMessage, session);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Reply destination: " + destination));
                    }
                    if (destination != null) {
                        Object replyResult = replyMessage;
                        if (this.extractReplyPayload) {
                            replyResult = replyMessage.getPayload();
                        }
                        try {
                            javax.jms.Message jmsReply = this.messageConverter.toMessage(replyResult, session);
                            this.headerMapper.fromHeaders(replyMessage.getHeaders(), jmsReply);
                            this.copyCorrelationIdFromRequestToReply(jmsMessage, jmsReply);
                            this.sendReply(jmsReply, destination, session);
                        }
                        catch (RuntimeException e) {
                            this.logger.error((Object)("Failed to generate JMS Reply Message from: " + replyResult), (Throwable)e);
                            throw e;
                        }
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"expected a reply but none was received");
                }
            }
        }
    }

    public void afterPropertiesSet() {
        if (this.beanFactory != null) {
            this.gatewayDelegate.setBeanFactory(this.beanFactory);
        }
        this.gatewayDelegate.afterPropertiesSet();
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
    }

    protected void start() {
        this.gatewayDelegate.start();
    }

    protected void stop() {
        this.gatewayDelegate.stop();
    }

    private void copyCorrelationIdFromRequestToReply(javax.jms.Message requestMessage, javax.jms.Message replyMessage) throws JMSException {
        if (this.correlationKey != null) {
            if (this.correlationKey.equals("JMSCorrelationID")) {
                replyMessage.setJMSCorrelationID(requestMessage.getJMSCorrelationID());
            } else {
                String value = requestMessage.getStringProperty(this.correlationKey);
                if (value != null) {
                    replyMessage.setStringProperty(this.correlationKey, value);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("No property value available on request Message for correlationKey '" + this.correlationKey + "'"));
                }
            }
        } else if (replyMessage.getJMSCorrelationID() == null) {
            replyMessage.setJMSCorrelationID(requestMessage.getJMSMessageID());
        }
    }

    private Destination getReplyDestination(javax.jms.Message request, Session session) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && (replyTo = this.resolveDefaultReplyDestination(session)) == null) {
            throw new InvalidDestinationException("Cannot determine reply destination: Request message does not contain reply-to destination, and no default reply destination set.");
        }
        return replyTo;
    }

    private Destination resolveDefaultReplyDestination(Session session) throws JMSException {
        if (this.defaultReplyDestination instanceof Destination) {
            return (Destination)this.defaultReplyDestination;
        }
        if (this.defaultReplyDestination instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)this.defaultReplyDestination;
            return this.destinationResolver.resolveDestinationName(session, nameHolder.name, nameHolder.isTopic);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReply(javax.jms.Message replyMessage, Destination destination, Session session) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        try {
            if (this.explicitQosEnabledForReplies) {
                producer.send(replyMessage, this.replyDeliveryMode, this.replyPriority, this.replyTimeToLive);
            } else {
                producer.send(replyMessage);
            }
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)producer);
        }
    }

    private class GatewayDelegate
    extends MessagingGatewaySupport {
        GatewayDelegate() {
        }

        protected void send(Object request) {
            super.send(request);
        }

        protected Message<?> sendAndReceiveMessage(Object request) {
            return super.sendAndReceiveMessage(request);
        }

        protected ErrorMessage buildErrorMessage(Throwable throwable) {
            return super.buildErrorMessage(null, throwable);
        }

        protected MessagingTemplate getMessagingTemplate() {
            return this.messagingTemplate;
        }

        public String getComponentType() {
            if (ChannelPublishingJmsMessageListener.this.expectReply) {
                return "jms:inbound-gateway";
            }
            return "jms:message-driven-channel-adapter";
        }
    }

    private static final class DestinationNameHolder {
        private final String name;
        private final boolean isTopic;

        DestinationNameHolder(String name, boolean isTopic) {
            this.name = name;
            this.isTopic = isTopic;
        }
    }
}

