/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import org.springframework.integration.jms.PollableJmsChannel;
import org.springframework.integration.jms.dsl.JmsDefaultListenerContainerSpec;
import org.springframework.integration.jms.dsl.JmsInboundChannelAdapterSpec;
import org.springframework.integration.jms.dsl.JmsInboundGatewaySpec;
import org.springframework.integration.jms.dsl.JmsListenerContainerSpec;
import org.springframework.integration.jms.dsl.JmsMessageChannelSpec;
import org.springframework.integration.jms.dsl.JmsMessageDrivenChannelAdapterSpec;
import org.springframework.integration.jms.dsl.JmsOutboundChannelAdapterSpec;
import org.springframework.integration.jms.dsl.JmsOutboundGatewaySpec;
import org.springframework.integration.jms.dsl.JmsPollableMessageChannelSpec;
import org.springframework.integration.jms.dsl.JmsPublishSubscribeMessageChannelSpec;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.lang.Nullable;

public final class Jms {
    public static JmsPollableMessageChannelSpec<?, PollableJmsChannel> pollableChannel(ConnectionFactory connectionFactory) {
        return Jms.pollableChannel(null, connectionFactory);
    }

    public static JmsPollableMessageChannelSpec<?, PollableJmsChannel> pollableChannel(@Nullable String id, ConnectionFactory connectionFactory) {
        JmsPollableMessageChannelSpec spec = new JmsPollableMessageChannelSpec(connectionFactory);
        return spec.id(id);
    }

    public static JmsMessageChannelSpec<?, ?> channel(ConnectionFactory connectionFactory) {
        return Jms.channel(null, connectionFactory);
    }

    public static JmsMessageChannelSpec<?, ?> channel(@Nullable String id, ConnectionFactory connectionFactory) {
        return (JmsMessageChannelSpec)((Object)new JmsMessageChannelSpec(connectionFactory).id(id));
    }

    public static JmsPublishSubscribeMessageChannelSpec publishSubscribeChannel(ConnectionFactory connectionFactory) {
        return Jms.publishSubscribeChannel(null, connectionFactory);
    }

    public static JmsPublishSubscribeMessageChannelSpec publishSubscribeChannel(@Nullable String id, ConnectionFactory connectionFactory) {
        return (JmsPublishSubscribeMessageChannelSpec)((Object)new JmsPublishSubscribeMessageChannelSpec(connectionFactory).id(id));
    }

    public static JmsOutboundChannelAdapterSpec<?> outboundAdapter(JmsTemplate jmsTemplate) {
        return new JmsOutboundChannelAdapterSpec(jmsTemplate);
    }

    public static JmsOutboundChannelAdapterSpec.JmsOutboundChannelSpecTemplateAware outboundAdapter(ConnectionFactory connectionFactory) {
        return new JmsOutboundChannelAdapterSpec.JmsOutboundChannelSpecTemplateAware(connectionFactory);
    }

    public static JmsInboundChannelAdapterSpec<?> inboundAdapter(JmsTemplate jmsTemplate) {
        return new JmsInboundChannelAdapterSpec(jmsTemplate);
    }

    public static JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware inboundAdapter(ConnectionFactory connectionFactory) {
        return new JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware(connectionFactory);
    }

    public static JmsOutboundGatewaySpec outboundGateway(ConnectionFactory connectionFactory) {
        return new JmsOutboundGatewaySpec(connectionFactory);
    }

    public static JmsInboundGatewaySpec<?> inboundGateway(AbstractMessageListenerContainer listenerContainer) {
        return new JmsInboundGatewaySpec(listenerContainer);
    }

    public static JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> inboundGateway(ConnectionFactory connectionFactory) {
        try {
            return new JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer>((JmsDefaultListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory)));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <C extends AbstractMessageListenerContainer> JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec<?, C> inboundGateway(ConnectionFactory connectionFactory, Class<C> containerClass) {
        try {
            JmsListenerContainerSpec spec = (JmsListenerContainerSpec)((Object)new JmsListenerContainerSpec(containerClass).connectionFactory(connectionFactory));
            return new JmsInboundGatewaySpec.JmsInboundGatewayListenerContainerSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsMessageDrivenChannelAdapterSpec<?> messageDrivenChannelAdapter(JmsListenerContainerSpec<?, ? extends AbstractMessageListenerContainer> jmsListenerContainerSpec) {
        return new JmsMessageDrivenChannelAdapterSpec((AbstractMessageListenerContainer)jmsListenerContainerSpec.get());
    }

    public static JmsMessageDrivenChannelAdapterSpec<?> messageDrivenChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        return new JmsMessageDrivenChannelAdapterSpec(listenerContainer);
    }

    public static JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer> messageDrivenChannelAdapter(ConnectionFactory connectionFactory) {
        try {
            return new JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<JmsDefaultListenerContainerSpec, DefaultMessageListenerContainer>((JmsDefaultListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory)));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <C extends AbstractMessageListenerContainer> JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec<?, C> messageDrivenChannelAdapter(ConnectionFactory connectionFactory, Class<C> containerClass) {
        try {
            JmsListenerContainerSpec spec = (JmsListenerContainerSpec)((Object)new JmsListenerContainerSpec(containerClass).connectionFactory(connectionFactory));
            return new JmsMessageDrivenChannelAdapterSpec.JmsMessageDrivenChannelAdapterListenerContainerSpec(spec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsDefaultListenerContainerSpec container(ConnectionFactory connectionFactory, Destination destination) {
        try {
            return (JmsDefaultListenerContainerSpec)((Object)((JmsDefaultListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory))).destination(destination));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static JmsDefaultListenerContainerSpec container(ConnectionFactory connectionFactory, String destinationName) {
        try {
            return (JmsDefaultListenerContainerSpec)((Object)((JmsDefaultListenerContainerSpec)((Object)new JmsDefaultListenerContainerSpec().connectionFactory(connectionFactory))).destination(destinationName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Jms() {
    }
}

