/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.dsl;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.function.Consumer;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.integration.jms.JmsInboundGateway;
import org.springframework.integration.jms.dsl.JmsListenerContainerSpec;
import org.springframework.integration.util.CheckedFunction;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public class JmsInboundGatewaySpec<S extends JmsInboundGatewaySpec<S>>
extends MessagingGatewaySpec<S, JmsInboundGateway> {
    protected JmsInboundGatewaySpec(AbstractMessageListenerContainer listenerContainer) {
        super((MessagingGatewaySupport)new JmsInboundGateway(listenerContainer, new ChannelPublishingJmsMessageListener()));
        ((JmsInboundGateway)((Object)this.target)).getListener().setExpectReply(true);
    }

    public S defaultReplyDestination(Destination defaultReplyDestination) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDefaultReplyDestination(defaultReplyDestination);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S defaultReplyQueueName(String destinationName) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDefaultReplyQueueName(destinationName);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S defaultReplyTopicName(String destinationName) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDefaultReplyTopicName(destinationName);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S replyTimeToLive(long replyTimeToLive) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyTimeToLive(replyTimeToLive);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S replyPriority(int replyPriority) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyPriority(replyPriority);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S replyDeliveryPersistent(boolean replyDeliveryPersistent) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyDeliveryPersistent(replyDeliveryPersistent);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S correlationKey(String correlationKey) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setCorrelationKey(correlationKey);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S explicitQosEnabledForReplies(boolean explicitQosEnabledForReplies) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setExplicitQosEnabledForReplies(explicitQosEnabledForReplies);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S destinationResolver(DestinationResolver destinationResolver) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setDestinationResolver(destinationResolver);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S replyToExpression(String replyToExpression) {
        return this.replyToExpression(PARSER.parseExpression(replyToExpression));
    }

    public S replyToFunction(CheckedFunction<Message, ?, JMSException> replyToFunction) {
        return this.replyToExpression((Expression)new FunctionExpression(replyToFunction.unchecked()));
    }

    public S replyToExpression(Expression replyToExpression) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setReplyToExpression(replyToExpression);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S jmsMessageConverter(MessageConverter messageConverter) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setMessageConverter(messageConverter);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S setHeaderMapper(JmsHeaderMapper headerMapper) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setHeaderMapper(headerMapper);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S extractRequestPayload(boolean extractRequestPayload) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setExtractRequestPayload(extractRequestPayload);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S extractReplyPayload(boolean extractReplyPayload) {
        ((JmsInboundGateway)((Object)this.target)).getListener().setExtractReplyPayload(extractReplyPayload);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public S shutdownContainerOnStop(boolean shutdown) {
        ((JmsInboundGateway)((Object)this.target)).setShutdownContainerOnStop(shutdown);
        return (S)((Object)((JmsInboundGatewaySpec)this._this()));
    }

    public static class JmsInboundGatewayListenerContainerSpec<S extends JmsListenerContainerSpec<S, C>, C extends AbstractMessageListenerContainer>
    extends JmsInboundGatewaySpec<JmsInboundGatewayListenerContainerSpec<S, C>> {
        private final S spec;

        protected JmsInboundGatewayListenerContainerSpec(S spec) {
            super((AbstractMessageListenerContainer)spec.getObject());
            this.spec = spec;
            ((AbstractMessageListenerContainer)this.spec.getObject()).setAutoStartup(false);
        }

        public JmsInboundGatewayListenerContainerSpec<S, C> requestDestination(Destination requestDestination) {
            ((JmsListenerContainerSpec)((Object)this.spec)).destination(requestDestination);
            return (JmsInboundGatewayListenerContainerSpec)this._this();
        }

        public JmsInboundGatewayListenerContainerSpec<S, C> requestDestination(String requestDestinationName) {
            ((JmsListenerContainerSpec)((Object)this.spec)).destination(requestDestinationName);
            return (JmsInboundGatewayListenerContainerSpec)this._this();
        }

        public JmsInboundGatewayListenerContainerSpec<S, C> configureListenerContainer(Consumer<S> configurer) {
            Assert.notNull(configurer, (String)"'configurer' must not be null");
            configurer.accept(this.spec);
            return (JmsInboundGatewayListenerContainerSpec)this._this();
        }
    }
}

