/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationInvokingMessageHandler
extends AbstractReplyProducingMessageHandler
implements InitializingBean {
    private volatile MBeanServer server;
    private volatile ObjectName objectName;
    private volatile String operationName;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setObjectName(String objectName) {
        try {
            if (objectName != null) {
                this.objectName = ObjectNameManager.getInstance((String)objectName);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public final void onInit() {
        Assert.notNull((Object)this.server, (String)"MBeanServer is required.");
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        ObjectName objectName = this.resolveObjectName(requestMessage);
        String operationName = this.resolveOperationName(requestMessage);
        Map<String, Object> paramsFromMessage = this.resolveParameters(requestMessage);
        try {
            MBeanInfo mbeanInfo = this.server.getMBeanInfo(objectName);
            MBeanOperationInfo[] opInfoArray = mbeanInfo.getOperations();
            boolean hasNoArgOption = false;
            for (MBeanOperationInfo opInfo : opInfoArray) {
                if (!operationName.equals(opInfo.getName())) continue;
                MBeanParameterInfo[] paramInfoArray = opInfo.getSignature();
                if (paramInfoArray.length == 0) {
                    hasNoArgOption = true;
                }
                if (paramInfoArray.length != paramsFromMessage.size()) continue;
                int index = 0;
                Object[] values = new Object[paramInfoArray.length];
                String[] signature = new String[paramInfoArray.length];
                for (MBeanParameterInfo paramInfo : paramInfoArray) {
                    Object value = paramsFromMessage.get(paramInfo.getName());
                    if (value == null || !value.getClass().getName().equals(paramInfo.getType())) continue;
                    values[index] = value;
                    signature[index] = paramInfo.getType();
                    ++index;
                }
                if (index != paramInfoArray.length) continue;
                return this.server.invoke(objectName, operationName, values, signature);
            }
            if (hasNoArgOption) {
                return this.server.invoke(objectName, operationName, null, null);
            }
            throw new MessagingException(requestMessage, "failed to find JMX operation '" + operationName + "' on MBean [" + objectName + "] of type [" + mbeanInfo.getClassName() + "] with " + paramsFromMessage.size() + " parameters: " + paramsFromMessage.keySet());
        }
        catch (JMException e) {
            throw new MessageHandlingException(requestMessage, "failed to invoke JMX operation '" + operationName + "' on MBean [" + objectName + "]" + " with " + paramsFromMessage.size() + " parameters: " + paramsFromMessage.keySet(), (Throwable)e);
        }
    }

    private ObjectName resolveObjectName(Message<?> message) {
        ObjectName objectName = this.objectName;
        if (objectName == null) {
            Object objectNameHeader = message.getHeaders().get((Object)"jmx_objectName");
            if (objectNameHeader instanceof ObjectName) {
                objectName = (ObjectName)objectNameHeader;
            } else if (objectNameHeader instanceof String) {
                try {
                    objectName = ObjectNameManager.getInstance((Object)objectNameHeader);
                }
                catch (MalformedObjectNameException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        Assert.notNull((Object)objectName, (String)"Failed to resolve ObjectName.");
        return objectName;
    }

    private String resolveOperationName(Message<?> message) {
        String operationName = this.operationName;
        if (operationName == null) {
            operationName = (String)message.getHeaders().get((Object)"jmx_operationName", String.class);
        }
        Assert.notNull((Object)operationName, (String)"Failed to resolve operation name.");
        return operationName;
    }

    private Map<String, Object> resolveParameters(Message<?> message) {
        Map<String, Object> map = null;
        map = message.getPayload() instanceof Map ? (Map<String, Object>)message.getPayload() : (message.getPayload() instanceof List ? this.createParameterMapFromList((List)message.getPayload()) : (message.getPayload() != null && message.getPayload().getClass().isArray() ? this.createParameterMapFromList(Arrays.asList(ObjectUtils.toObjectArray((Object)message.getPayload()))) : (message.getPayload() != null ? this.createParameterMapFromList(Collections.singletonList(message.getPayload())) : Collections.EMPTY_MAP)));
        return map;
    }

    private Map<String, Object> createParameterMapFromList(List parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < parameters.size(); ++i) {
            map.put("p" + (i + 1), parameters.get(i));
        }
        return map;
    }
}

